/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.request;

import java.io.File;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.netbeans.lib.cvsclient.request.Request;

public class NotifyRequest
extends Request {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd hh:mm:ss yyyy z", Locale.US);
    private static final String HOST_NAME;
    private final String request;

    static {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HOST_NAME = hostName;
    }

    public NotifyRequest(File file, String command, String parameters) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Notify ");
        buffer.append(file.getName());
        buffer.append('\n');
        buffer.append(command);
        buffer.append('\t');
        buffer.append(DATE_FORMAT.format(new Date()));
        buffer.append('\t');
        buffer.append(HOST_NAME);
        buffer.append('\t');
        buffer.append(file.getParent());
        buffer.append('\t');
        buffer.append(parameters);
        buffer.append('\n');
        this.request = buffer.toString();
    }

    public String getRequestString() {
        return this.request;
    }

    public boolean isResponseExpected() {
        return false;
    }
}

