/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.edit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;

public class EditCommand
extends BasicCommand {
    private boolean checkThatUnedited;
    private boolean forceEvenIfEdited;
    private Watch temporaryWatch;
    private transient ClientServices clientServices;

    public static File getEditBackupFile(File file) {
        return new File(file.getParent(), "CVS/Base/" + file.getName());
    }

    public EditCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        this.clientServices = clientServices;
        try {
            try {
                clientServices.ensureConnection();
                super.execute(clientServices, eventManager);
                this.addArgumentRequest(this.isCheckThatUnedited(), "-c");
                this.addArgumentRequest(this.isForceEvenIfEdited(), "-f");
                this.addRequestForWorkingDirectory(clientServices);
                this.addRequest(CommandRequest.NOOP);
                clientServices.processRequests(this.requests);
            }
            catch (AuthenticationException authenticationException) {
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (EOFException ex) {
                throw new CommandException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
        }
        finally {
            this.requests.clear();
            this.clientServices = null;
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        String temporaryWatch = Watch.getWatchString(this.getTemporaryWatch());
        this.requests.add(new NotifyRequest(file, "E", temporaryWatch));
        try {
            this.editFile(this.clientServices, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer cvsCommandLine = new StringBuffer("edit ");
        cvsCommandLine.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCheckThatUnedited(false);
        this.setForceEvenIfEdited(true);
        this.setTemporaryWatch(null);
    }

    public String getCVSArguments() {
        StringBuffer cvsArguments = new StringBuffer();
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        return cvsArguments.toString();
    }

    public boolean isCheckThatUnedited() {
        return this.checkThatUnedited;
    }

    public void setCheckThatUnedited(boolean checkThatUnedited) {
        this.checkThatUnedited = checkThatUnedited;
    }

    public boolean isForceEvenIfEdited() {
        return this.forceEvenIfEdited;
    }

    public void setForceEvenIfEdited(boolean forceEvenIfEdited) {
        this.forceEvenIfEdited = forceEvenIfEdited;
    }

    public Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public void setTemporaryWatch(Watch temporaryWatch) {
        this.temporaryWatch = temporaryWatch;
    }

    private void editFile(ClientServices clientServices, File file) throws IOException {
        this.addBaserevEntry(clientServices, file);
        FileUtils.copyFile(file, EditCommand.getEditBackupFile(file));
        FileUtils.setFileReadOnly(file, false);
    }

    private void addBaserevEntry(ClientServices clientServices, File file) throws IOException {
        Entry entry = clientServices.getEntry(file);
        if (entry == null || entry.getRevision() == null || entry.isNewUserFile() || entry.isUserFileToBeRemoved()) {
            throw new IllegalArgumentException("File does not have an Entry or Entry is invalid!");
        }
        File baserevFile = new File(file.getParentFile(), "CVS/Baserev");
        File backupFile = new File(String.valueOf(baserevFile.getAbsolutePath()) + '~');
        BufferedReader reader = null;
        BufferedWriter writer = null;
        boolean append = true;
        boolean writeFailed = true;
        String entryStart = String.valueOf('B') + file.getName() + '/';
        try {
            try {
                writer = new BufferedWriter(new FileWriter(backupFile));
                writeFailed = false;
                reader = new BufferedReader(new FileReader(baserevFile));
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith(entryStart)) {
                        append = false;
                    }
                    writeFailed = true;
                    writer.write(line);
                    writer.newLine();
                    writeFailed = false;
                    line = reader.readLine();
                }
            }
            catch (IOException ex) {
                if (writeFailed) {
                    throw ex;
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                try {
                    if (append && !writeFailed) {
                        writer.write(String.valueOf(entryStart) + entry.getRevision() + '/');
                        writer.newLine();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        baserevFile.delete();
        backupFile.renameTo(baserevFile);
    }
}

