/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

public class ModuleCompleteKey {
    private String pluginKey;
    private String moduleKey;

    public ModuleCompleteKey(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("Invalid complete key specified: " + completeKey);
        }
        int sepIdx = completeKey.indexOf(":");
        if (sepIdx <= 0 || sepIdx == completeKey.length() - 1) {
            throw new IllegalArgumentException("Invalid complete key specified: " + completeKey);
        }
        this.pluginKey = completeKey.substring(0, sepIdx);
        this.moduleKey = completeKey.substring(sepIdx + 1);
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getCompleteKey() {
        return this.pluginKey + ":" + this.moduleKey;
    }
}

