/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.util;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.ObjectUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class EntityUtils {
    private static final EntityOperator[] entityOperators = new EntityOperator[]{EntityOperator.EQUALS, EntityOperator.NOT_EQUAL, EntityOperator.LESS_THAN, EntityOperator.GREATER_THAN, EntityOperator.LESS_THAN_EQUAL_TO, EntityOperator.GREATER_THAN_EQUAL_TO, EntityOperator.IN, EntityOperator.BETWEEN, EntityOperator.NOT, EntityOperator.AND, EntityOperator.OR};

    public static EntityOperator getOperator(String code) {
        for (int i = 0; i < entityOperators.length; ++i) {
            EntityOperator operator = entityOperators[i];
            if (!operator.toString().trim().equals(code.trim())) continue;
            return operator;
        }
        return null;
    }

    public static GenericValue createValue(String entity, Map paramMap) throws GenericEntityException {
        HashMap<String, Long> params;
        HashMap<String, Long> hashMap = params = paramMap == null ? new HashMap<String, Long>() : new HashMap(paramMap);
        if (params.get("id") == null) {
            Long id = CoreFactory.getGenericDelegator().getNextSeqId(entity);
            params.put("id", id);
        }
        GenericValue v = CoreFactory.getGenericDelegator().makeValue(entity, params);
        v.create();
        return v;
    }

    public static boolean identical(GenericValue v1, GenericValue v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (!v1.getEntityName().equals(v2.getEntityName())) {
            return false;
        }
        Iterator iterator = v1.getAllKeys().iterator();
        while (iterator.hasNext()) {
            Timestamp t2;
            Timestamp t1;
            String key = (String)iterator.next();
            if (v1.get(key) == null && v2.get(key) == null) continue;
            if (v1.get(key) == null && v2.get(key) != null) {
                return false;
            }
            if (!(v1.get(key) instanceof Timestamp && v2.get(key) instanceof Timestamp ? !DateUtils.equalTimestamps((Timestamp)(t1 = (Timestamp)v1.get(key)), (Timestamp)(t2 = (Timestamp)v2.get(key))) : !v1.get(key).equals(v2.get(key)))) continue;
            return false;
        }
        ArrayList uncheckedKeys = new ArrayList(v2.getAllKeys());
        uncheckedKeys.removeAll(v1.getAllKeys());
        if (uncheckedKeys.size() > 0) {
            Iterator iterator2 = uncheckedKeys.iterator();
            while (iterator2.hasNext()) {
                String key = (String)iterator2.next();
                if (v2.get(key) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean contains(Collection entities, GenericValue entity) {
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            GenericValue gv = (GenericValue)iterator.next();
            if (!EntityUtils.identical(gv, entity)) continue;
            return true;
        }
        return false;
    }

    public static List filterByAnd(List values, List exprs) {
        if (values == null) {
            return null;
        }
        if (exprs == null || exprs.size() == 0) {
            return values;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            GenericValue value = (GenericValue)iterator.next();
            boolean include = true;
            Iterator exprIter = exprs.iterator();
            while (exprIter.hasNext()) {
                EntityExpr expr = (EntityExpr)exprIter.next();
                Object lhs = value.get((String)expr.getLhs());
                Object rhs = expr.getRhs();
                if (EntityOperator.EQUALS.equals((Object)expr.getOperator())) {
                    include = ObjectUtils.isIdentical((Object)lhs, (Object)rhs);
                    if (include) continue;
                    break;
                }
                if (EntityOperator.NOT_EQUAL.equals((Object)expr.getOperator())) {
                    include = ObjectUtils.isDifferent((Object)lhs, (Object)rhs);
                    if (include) continue;
                    break;
                }
                if (EntityOperator.GREATER_THAN.equals((Object)expr.getOperator()) || EntityOperator.GREATER_THAN_EQUAL_TO.equals((Object)expr.getOperator()) || EntityOperator.LESS_THAN.equals((Object)expr.getOperator()) || EntityOperator.LESS_THAN_EQUAL_TO.equals((Object)expr.getOperator())) {
                    if (rhs != null && lhs != null && rhs instanceof Comparable) {
                        Comparable lhsComp = (Comparable)lhs;
                        Comparable rhsComp = (Comparable)rhs;
                        int comparison = lhsComp.compareTo(rhsComp);
                        if (comparison <= 0 && EntityOperator.LESS_THAN_EQUAL_TO.equals((Object)expr.getOperator())) {
                            include = true;
                            continue;
                        }
                        if (comparison < 0 && EntityOperator.LESS_THAN.equals((Object)expr.getOperator())) {
                            include = true;
                            continue;
                        }
                        if (comparison >= 0 && EntityOperator.GREATER_THAN_EQUAL_TO.equals((Object)expr.getOperator())) {
                            include = true;
                            continue;
                        }
                        if (comparison > 0 && EntityOperator.GREATER_THAN.equals((Object)expr.getOperator())) {
                            include = true;
                            continue;
                        }
                        include = false;
                        break;
                    }
                    throw new IllegalArgumentException("Operation " + expr.getOperator().getCode() + " is not yet supported by filterByAnd with objects that do not implement Comparable");
                }
                throw new IllegalArgumentException("Operation " + expr.getOperator().getCode() + " is not yet supported by filterByAnd");
            }
            if (!include) continue;
            result.add(value);
        }
        return result;
    }

    public static synchronized String getNextStringId(String entityName) throws GenericEntityException {
        long maxID = 1L;
        Iterator iterator = CoreFactory.getGenericDelegator().findAll(entityName).iterator();
        while (iterator.hasNext()) {
            GenericValue entity = (GenericValue)iterator.next();
            try {
                long entityId = Long.parseLong(entity.getString("id"));
                if (entityId < maxID) continue;
                maxID = entityId + 1L;
            }
            catch (NumberFormatException nfe) {}
        }
        return Long.toString(maxID);
    }
}

