/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity.user;

import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.service.GroupMembershipManager;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdDataAccessException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class CrowdUserDetailsServiceImpl
implements CrowdUserDetailsService {
    protected static final Logger LOGGER = Logger.getLogger(CrowdUserDetails.class);
    private UserManager userManager;
    private AuthenticationManager authenticationManager;
    private GroupMembershipManager groupMembershipManager;
    private String authorityPrefix = "";
    private String authoritySuffix = null;

    public CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            SOAPPrincipal principal = this.userManager.getUser(username);
            return new CrowdUserDetails(principal, this.getAuthorities(principal.getName()));
        }
        catch (InvalidAuthorizationTokenException e) {
            LOGGER.error((Object)e);
            throw new CrowdDataAccessException(e);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e);
            throw new CrowdDataAccessException(e);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.info((Object)("Could not find principal in Crowd with username: " + username));
            throw new UsernameNotFoundException("Could not find principal in Crowd with username: " + username, (Throwable)e);
        }
    }

    public CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        try {
            SOAPPrincipal principal = this.userManager.getUserFromToken(token);
            return new CrowdUserDetails(principal, this.getAuthorities(principal.getName()));
        }
        catch (InvalidAuthorizationTokenException e) {
            LOGGER.error((Object)e);
            throw new CrowdDataAccessException(e);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e);
            throw new CrowdDataAccessException(e);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)e);
            throw new CrowdDataAccessException(e);
        }
        catch (InvalidTokenException e) {
            throw new CrowdSSOTokenInvalidException(e.getMessage(), e);
        }
    }

    protected GrantedAuthority[] getAuthorities(String username) throws InvalidAuthorizationTokenException, RemoteException, ObjectNotFoundException {
        List authorities;
        List userGroups = this.groupMembershipManager.getMemberships(username);
        if (this.authoritySuffix == null) {
            authorities = this.generateAuthoritiesFromGroupNames(userGroups);
        } else {
            List<String> authorizedGroups = Arrays.asList(this.authenticationManager.getSecurityServerClient().getGrantedAuthorities());
            authorities = this.generateAuthorityFromSuffix(userGroups, authorizedGroups);
        }
        return authorities.toArray(new GrantedAuthority[authorities.size()]);
    }

    private List generateAuthorityFromSuffix(List userGroups, List authorizedGroups) {
        ArrayList<GrantedAuthorityImpl> authorities = new ArrayList<GrantedAuthorityImpl>();
        if (userGroups != null) {
            for (String userGroup : userGroups) {
                if (!authorizedGroups.contains(userGroup)) continue;
                authorities.add(new GrantedAuthorityImpl(this.getAuthorityPrefix() + this.getAuthoritySuffix()));
                break;
            }
        }
        return authorities;
    }

    private List generateAuthoritiesFromGroupNames(List userGroups) {
        ArrayList<GrantedAuthorityImpl> authorities = new ArrayList<GrantedAuthorityImpl>();
        Iterator iterator = userGroups.iterator();
        while (iterator.hasNext()) {
            authorities.add(new GrantedAuthorityImpl(this.getAuthorityPrefix() + iterator.next()));
        }
        return authorities;
    }

    public String getAuthorityPrefix() {
        return this.authorityPrefix;
    }

    public void setAuthorityPrefix(String authorityPrefix) {
        this.authorityPrefix = authorityPrefix;
    }

    public String getAuthoritySuffix() {
        return this.authoritySuffix;
    }

    public void setAuthoritySuffix(String authoritySuffix) {
        this.authoritySuffix = authoritySuffix;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setGroupMembershipManager(GroupMembershipManager groupMembershipManager) {
        this.groupMembershipManager = groupMembershipManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

