/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.security;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.security.Security;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilMisc;

public class OFBizSecurity
extends Security {
    public static final String module = OFBizSecurity.class.getName();
    public static final Map simpleRoleEntity = UtilMisc.toMap((String)"ORDERMGR", (Object)UtilMisc.toMap((String)"name", (Object)"OrderRole", (String)"pkey", (Object)"orderId"), (String)"FACILITY", (Object)UtilMisc.toMap((String)"name", (Object)"FacilityRole", (String)"pkey", (Object)"facilityId"), (String)"MARKETING", (Object)UtilMisc.toMap((String)"name", (Object)"MarketingCampaignRole", (String)"pkey", (Object)"marketingCampaignId"));
    public static UtilCache userLoginSecurityGroupByUserLoginId = new UtilCache("security.UserLoginSecurityGroupByUserLoginId");
    public static UtilCache securityGroupPermissionCache = new UtilCache("security.SecurityGroupPermissionCache");
    GenericDelegator delegator = null;

    protected OFBizSecurity() {
    }

    protected OFBizSecurity(GenericDelegator delegator) {
        this.delegator = delegator;
    }

    public GenericDelegator getDelegator() {
        return this.delegator;
    }

    public void setDelegator(GenericDelegator delegator) {
        this.delegator = delegator;
    }

    public Iterator findUserLoginSecurityGroupByUserLoginId(String userLoginId) {
        LinkedList collection = (LinkedList)userLoginSecurityGroupByUserLoginId.get((Object)userLoginId);
        if (collection == null) {
            try {
                collection = this.delegator.findByAnd("UserLoginSecurityGroup", UtilMisc.toMap((String)"userLoginId", (Object)userLoginId), null);
            }
            catch (GenericEntityException e) {
                Debug.logWarning((Throwable)e);
            }
            if (collection == null) {
                collection = new LinkedList();
            }
            userLoginSecurityGroupByUserLoginId.put((Object)userLoginId, collection);
        }
        collection = EntityUtil.filterByDate((List)collection, (boolean)true);
        return collection.iterator();
    }

    public boolean securityGroupPermissionExists(String groupId, String permission) {
        GenericValue securityGroupPermissionValue = this.delegator.makeValue("SecurityGroupPermission", UtilMisc.toMap((String)"groupId", (Object)groupId, (String)"permissionId", (Object)permission));
        Boolean exists = (Boolean)securityGroupPermissionCache.get((Object)securityGroupPermissionValue);
        if (exists == null) {
            try {
                exists = this.delegator.findByPrimaryKey(securityGroupPermissionValue.getPrimaryKey()) != null ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (GenericEntityException e) {
                exists = Boolean.FALSE;
                Debug.logWarning((Throwable)e);
            }
            securityGroupPermissionCache.put((Object)securityGroupPermissionValue, (Object)exists);
        }
        return exists;
    }

    public boolean hasPermission(String permission, HttpSession session) {
        GenericValue userLogin = (GenericValue)session.getAttribute("userLogin");
        if (userLogin == null) {
            return false;
        }
        return this.hasPermission(permission, userLogin);
    }

    public boolean hasPermission(String permission, GenericValue userLogin) {
        if (userLogin == null) {
            return false;
        }
        Iterator iterator = this.findUserLoginSecurityGroupByUserLoginId(userLogin.getString("userLoginId"));
        GenericValue userLoginSecurityGroup = null;
        while (iterator.hasNext()) {
            userLoginSecurityGroup = (GenericValue)iterator.next();
            if (!this.securityGroupPermissionExists(userLoginSecurityGroup.getString("groupId"), permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEntityPermission(String entity, String action, HttpSession session) {
        GenericValue userLogin = (GenericValue)session.getAttribute("userLogin");
        if (userLogin == null) {
            return false;
        }
        return this.hasEntityPermission(entity, action, userLogin);
    }

    public boolean hasEntityPermission(String entity, String action, GenericValue userLogin) {
        if (userLogin == null) {
            return false;
        }
        Iterator iterator = this.findUserLoginSecurityGroupByUserLoginId(userLogin.getString("userLoginId"));
        GenericValue userLoginSecurityGroup = null;
        while (iterator.hasNext()) {
            userLoginSecurityGroup = (GenericValue)iterator.next();
            if (this.securityGroupPermissionExists(userLoginSecurityGroup.getString("groupId"), entity + "_ADMIN")) {
                return true;
            }
            if (!this.securityGroupPermissionExists(userLoginSecurityGroup.getString("groupId"), entity + action)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRolePermission(String application, String action, String primaryKey, String role, HttpSession session) {
        GenericValue userLogin = (GenericValue)session.getAttribute("userLogin");
        return this.hasRolePermission(application, action, primaryKey, role, userLogin);
    }

    public boolean hasRolePermission(String application, String action, String primaryKey, String role, GenericValue userLogin) {
        List roles = null;
        if (role != null && !role.equals("")) {
            roles = UtilMisc.toList((Object)role);
        }
        return this.hasRolePermission(application, action, primaryKey, roles, userLogin);
    }

    public boolean hasRolePermission(String application, String action, String primaryKey, List roles, HttpSession session) {
        GenericValue userLogin = (GenericValue)session.getAttribute("userLogin");
        return this.hasRolePermission(application, action, primaryKey, roles, userLogin);
    }

    public boolean hasRolePermission(String application, String action, String primaryKey, List roles, GenericValue userLogin) {
        Map simpleRoleMap;
        String entityName = null;
        EntityConditionList condition = null;
        if (userLogin == null) {
            return false;
        }
        if (primaryKey.equals("") && roles == null) {
            if (this.hasEntityPermission(application, action, userLogin)) {
                return true;
            }
            if (this.hasEntityPermission(application, action + "_ROLE", userLogin)) {
                return true;
            }
        }
        if ((simpleRoleMap = (Map)simpleRoleEntity.get(application)) != null && roles != null) {
            entityName = (String)simpleRoleMap.get("name");
            String pkey = (String)simpleRoleMap.get("pkey");
            if (pkey != null) {
                ArrayList<EntityExpr> expressions = new ArrayList<EntityExpr>();
                for (String role : roles) {
                    expressions.add(new EntityExpr("roleTypeId", EntityOperator.EQUALS, (Object)role));
                }
                EntityExprList exprList = new EntityExprList(expressions, EntityOperator.OR);
                EntityExpr keyExpr = new EntityExpr(pkey, EntityOperator.EQUALS, (Object)primaryKey);
                EntityExpr partyExpr = new EntityExpr("partyId", EntityOperator.EQUALS, (Object)userLogin.getString("partyId"));
                List joinList = UtilMisc.toList((Object)exprList, (Object)keyExpr, (Object)partyExpr);
                condition = new EntityConditionList(joinList, EntityOperator.AND);
            }
        }
        return this.hasRolePermission(application, action, entityName, (EntityCondition)condition, userLogin);
    }

    public boolean hasRolePermission(String application, String action, String entityName, EntityCondition condition, GenericValue userLogin) {
        if (userLogin == null) {
            return false;
        }
        if (this.hasEntityPermission(application, action, userLogin)) {
            return true;
        }
        if (entityName == null || condition == null) {
            return false;
        }
        if (this.hasEntityPermission(application, action + "_ROLE", userLogin)) {
            List roleTest = null;
            try {
                roleTest = this.delegator.findByCondition(entityName, condition, null, null);
            }
            catch (GenericEntityException e) {
                Debug.logError((Throwable)e, (String)("Problems doing role security lookup on entity [" + entityName + "] using [" + condition + "]"), (String)module);
                return false;
            }
            if (roleTest != null && roleTest.size() > 0) {
                return true;
            }
        }
        return false;
    }
}

