/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.service;

import com.atlassian.core.user.GroupUtils;
import com.atlassian.core.user.UserUtils;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.group.GroupRemoveUserMapper;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.rpc.exception.RemoteValidationException;
import com.atlassian.jira.rpc.soap.beans.RemoteFilter;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.service.UserService;
import com.atlassian.jira.rpc.soap.util.RemoteEntityFactory;
import com.atlassian.jira.rpc.soap.util.SoapUtils;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.EasyList;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.opensymphony.user.DuplicateEntityException;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.Group;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserServiceImpl
implements UserService {
    private PermissionManager permissionManager;
    private SearchRequestService searchRequestService;
    private UserManager userManager;
    private ApplicationProperties applicationProperties;
    private SearchProvider searchProvider;
    private IssueIndexManager indexManager;
    private final GroupService groupService;
    private com.atlassian.jira.bc.user.UserService userService;
    private final RemoteEntityFactory remoteEntityFactory;

    public UserServiceImpl(SearchRequestService searchRequestService, UserManager userManager, PermissionManager permissionManager, ApplicationProperties applicationProperties, SearchProvider searchProvider, IssueIndexManager indexManager, com.atlassian.jira.bc.user.UserService userService, GroupService groupService, RemoteEntityFactory remoteEntityFactory) {
        this.searchRequestService = searchRequestService;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.searchProvider = searchProvider;
        this.indexManager = indexManager;
        this.userService = userService;
        this.groupService = groupService;
        this.remoteEntityFactory = remoteEntityFactory;
    }

    public RemoteUser getUser(User currentUser, String username) {
        try {
            User foundUser = UserUtils.getUser((String)username);
            return this.remoteEntityFactory.createUser(foundUser);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public RemoteUser createUser(User remoteUser, String username, String password, String fullName, String email) throws RemoteValidationException, RemotePermissionException {
        UserService.CreateUserValidationResult result = this.userService.validateCreateUserForAdminPasswordRequired(remoteUser, username, password, password, email, fullName);
        if (!result.isValid()) {
            throw new RemoteValidationException("Error creating user", result.getErrorCollection());
        }
        try {
            User user = this.userService.createUser(result);
            return this.remoteEntityFactory.createUser(user);
        }
        catch (ImmutableException e) {
            throw new RemoteValidationException("cannot create user details, cause: " + e.getMessage(), e);
        }
        catch (DuplicateEntityException e) {
            throw new RemoteValidationException("user for this name already exists, please choose a different user name");
        }
    }

    public void deleteUser(User remoteUser, String username) throws RemoteException {
        UserService.DeleteUserValidationResult result = this.userService.validateDeleteUser(remoteUser, username);
        if (!result.isValid()) {
            throw new RemoteValidationException("Error removing user", result.getErrorCollection());
        }
        try {
            this.userService.removeUser(remoteUser, result);
        }
        catch (Exception e) {
            throw new RemoteException("Unable to delete user, cause: " + e.getMessage(), e);
        }
    }

    public RemoteGroup getGroup(User admin, String groupName) throws RemoteException {
        if (!this.permissionManager.hasPermission(0, admin)) {
            throw new RemotePermissionException("You do not have permission to get a group.");
        }
        if (groupName == null) {
            throw new RemoteValidationException("group name cannot be null, needs a value");
        }
        Group group = GroupUtils.getGroup((String)groupName);
        if (group == null) {
            throw new RemoteValidationException("no group found for that groupName: " + groupName);
        }
        return this.remoteEntityFactory.createGroup(group);
    }

    public RemoteGroup createGroup(User admin, String groupName, RemoteUser firstUser) throws RemoteException {
        Group group;
        if (!this.permissionManager.hasPermission(0, admin)) {
            throw new RemotePermissionException("You do not have permission to create a group.");
        }
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            throw new RemoteValidationException("Cannot create group, as external user management is enabled. Contact your administrator.");
        }
        if (groupName == null) {
            throw new RemoteValidationException("group cannot be created, group name cannot be null, needs a value");
        }
        User osFirstUser = null;
        if (firstUser != null) {
            try {
                osFirstUser = UserUtils.getUser((String)firstUser.getName());
            }
            catch (EntityNotFoundException e) {
                throw new RemoteValidationException("group cannot be created, first user for this group doesn't exist");
            }
        }
        try {
            group = this.userManager.createGroup(groupName);
            if (osFirstUser != null) {
                group.addUser(osFirstUser);
            }
        }
        catch (Exception e) {
            throw new RemoteValidationException("group cannot be created, group for that groupName already exists: " + groupName);
        }
        return this.remoteEntityFactory.createGroup(group);
    }

    public void addUserToGroup(User admin, RemoteGroup remoteGroup, RemoteUser remoteUser) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(admin, (ErrorCollection)errorCollection);
        List groups = EasyList.build((Object)remoteGroup.getName());
        if (this.groupService.validateAddUserToGroup((JiraServiceContext)jiraServiceContext, (Collection)groups, remoteUser.getName()) && this.groupService.addUsersToGroups((JiraServiceContext)jiraServiceContext, (Collection)groups, (Collection)EasyList.build((Object)remoteUser.getName()))) {
            return;
        }
        throw new RemoteValidationException("Can not add user '" + remoteUser.getName() + "' to group '" + remoteGroup.getName() + "'.", (ErrorCollection)errorCollection);
    }

    public void removeUserFromGroup(User admin, RemoteGroup remoteGroup, RemoteUser remoteUser) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(admin, (ErrorCollection)errorCollection);
        List groups = EasyList.build((Object)remoteGroup.getName());
        if (this.groupService.validateRemoveUserFromGroups((JiraServiceContext)jiraServiceContext, groups, remoteUser.getName())) {
            GroupRemoveUserMapper groupRemoveUserMapper = new GroupRemoveUserMapper();
            groupRemoveUserMapper.register(remoteUser.getName(), remoteGroup.getName());
            if (this.groupService.removeUsersFromGroups((JiraServiceContext)jiraServiceContext, groupRemoveUserMapper)) {
                return;
            }
        }
        throw new RemoteValidationException("Can not remove user '" + remoteUser.getName() + "' from group '" + remoteGroup.getName() + "'.", (ErrorCollection)errorCollection);
    }

    public RemoteGroup updateGroup(User admin, RemoteGroup remoteGroup) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(admin, (ErrorCollection)errorCollection);
        Group group = this.getGroup(remoteGroup);
        Collection userNamesToAdd = this.getUsersToAddToGroup(remoteGroup, group);
        this.addUsersToGroup(remoteGroup, jiraServiceContext, userNamesToAdd, (ErrorCollection)errorCollection);
        this.removeUsersFromGroup(group, remoteGroup, jiraServiceContext, (ErrorCollection)errorCollection);
        return this.remoteEntityFactory.createGroup(group);
    }

    private void removeUsersFromGroup(Group group, RemoteGroup remoteGroup, JiraServiceContextImpl jiraServiceContext, ErrorCollection errorCollection) throws RemoteValidationException {
        GroupRemoveUserMapper groupRemoveUserMapper = this.getRemoveUserMapper(group, remoteGroup);
        if (this.groupService.validateRemoveUsersFromGroups((JiraServiceContext)jiraServiceContext, groupRemoveUserMapper) && this.groupService.removeUsersFromGroups((JiraServiceContext)jiraServiceContext, groupRemoveUserMapper)) {
            return;
        }
        throw new RemoteValidationException("Errors during update group. Error with removing users from the group.", errorCollection);
    }

    private void addUsersToGroup(RemoteGroup remoteGroup, JiraServiceContextImpl jiraServiceContext, Collection userNamesToAdd, ErrorCollection errorCollection) throws RemoteValidationException {
        List groupsToJoin = EasyList.build((Object)remoteGroup.getName());
        if (this.groupService.validateAddUsersToGroup((JiraServiceContext)jiraServiceContext, (Collection)groupsToJoin, userNamesToAdd).isSuccess()) {
            this.groupService.addUsersToGroups((JiraServiceContext)jiraServiceContext, (Collection)groupsToJoin, userNamesToAdd);
        }
        if (errorCollection.hasAnyErrors()) {
            throw new RemoteValidationException("Errors during update group. Error with adding users to the group.", errorCollection);
        }
    }

    private GroupRemoveUserMapper getRemoveUserMapper(Group group, RemoteGroup remoteGroup) {
        GroupRemoveUserMapper groupRemoveUserMapper = new GroupRemoveUserMapper(EasyList.build((Object)remoteGroup.getName()));
        for (int i = 0; i < group.getUsers().size(); ++i) {
            String userName = (String)group.getUsers().get(i);
            if (this.groupContainsUserWithUsername(userName, remoteGroup)) continue;
            groupRemoveUserMapper.register(userName);
        }
        return groupRemoveUserMapper;
    }

    private Collection getUsersToAddToGroup(RemoteGroup remoteGroup, Group group) {
        ArrayList<String> userNamesToAdd = new ArrayList<String>();
        for (int i = 0; i < remoteGroup.getUsers().length; ++i) {
            RemoteUser remoteUser = remoteGroup.getUsers()[i];
            if (remoteUser == null || group.containsUser(remoteUser.getName())) continue;
            userNamesToAdd.add(remoteUser.getName());
        }
        return userNamesToAdd;
    }

    private boolean groupContainsUserWithUsername(String username, RemoteGroup group) {
        for (int i = 0; i < group.getUsers().length; ++i) {
            RemoteUser remoteUser = group.getUsers()[i];
            if (remoteUser.getName() == null || !remoteUser.getName().equals(username)) continue;
            return true;
        }
        return false;
    }

    private Group getGroup(RemoteGroup remoteGroup) throws RemotePermissionException, RemoteValidationException {
        Group group = GroupUtils.getGroup((String)remoteGroup.getName());
        if (group == null) {
            throw new RemoteValidationException("group cannot be updated, because it doesn't exist.");
        }
        return group;
    }

    public void deleteGroup(User admin, String groupName, String swapGroupName) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(admin, (ErrorCollection)errorCollection);
        if (!this.groupService.validateDelete((JiraServiceContext)jiraServiceContext, groupName, swapGroupName)) {
            throw new RemoteValidationException("Error validating group deletion.", (ErrorCollection)errorCollection);
        }
        if (!this.groupService.delete((JiraServiceContext)jiraServiceContext, groupName, swapGroupName)) {
            throw new RemoteValidationException("Error deleting group.", (ErrorCollection)errorCollection);
        }
    }

    public RemoteFilter[] getFavouriteFilters(User user) throws RemoteException {
        return SoapUtils.getFilters(this.searchRequestService.getFavouriteFilters(user));
    }
}

