/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.GenericCollectionComponentAdapter;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ConstructorInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private transient boolean instantiating;
    private transient List sortedMatchingConstructors;
    static /* synthetic */ Class class$java$lang$reflect$Array;

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses);
    }

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) {
        this(componentKey, componentImplementation, parameters, false);
    }

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, null);
    }

    protected Constructor getGreediestSatisifableConstructor(List adapterInstantiationOrderTrackingList) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor greediestConstructor = null;
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        if (this.sortedMatchingConstructors == null) {
            this.sortedMatchingConstructors = this.getSortedMatchingConstructors();
        }
        for (int i = 0; i < this.sortedMatchingConstructors.size(); ++i) {
            ArrayList<ComponentAdapter> adapterDependencies = new ArrayList<ComponentAdapter>();
            boolean failedDependency = false;
            Constructor constructor = (Constructor)this.sortedMatchingConstructors.get(i);
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                ComponentAdapter adapter = currentParameters[j].resolveAdapter(this.getContainer(), parameterTypes[j]);
                if (adapter == null) {
                    if (parameterTypes[j].getComponentType() != null) {
                        ComponentAdapter genericCollectionComponentAdapter = this.getGenericCollectionComponentAdapter(parameterTypes[j].getComponentType());
                        if (genericCollectionComponentAdapter != null) {
                            genericCollectionComponentAdapter.setContainer(this.getContainer());
                            adapterDependencies.add(genericCollectionComponentAdapter);
                            continue;
                        }
                        failedDependency = true;
                        unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                        continue;
                    }
                    failedDependency = true;
                    unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                    continue;
                }
                if (adapter.equals(this)) {
                    failedDependency = true;
                    unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                    continue;
                }
                if (this.getComponentKey().equals(adapter.getComponentKey())) {
                    failedDependency = true;
                    unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                    continue;
                }
                adapterDependencies.add(adapter);
            }
            if (failedDependency) continue;
            if (conflicts.size() == 0 && greediestConstructor == null) {
                greediestConstructor = constructor;
                adapterInstantiationOrderTrackingList.addAll(adapterDependencies);
                continue;
            }
            if (conflicts.size() == 0 && greediestConstructor.getParameterTypes().length > parameterTypes.length) break;
            if (greediestConstructor != null) {
                conflicts.add(greediestConstructor);
                greediestConstructor = null;
            }
            conflicts.add(constructor);
            adapterInstantiationOrderTrackingList.clear();
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && unsatisfiableDependencyTypes.size() > 0) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiableDependencyTypes);
        }
        if (greediestConstructor == null) {
            HashSet nonMatching = new HashSet();
            Constructor<?>[] constructors = this.getComponentImplementation().getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                if (this.sortedMatchingConstructors.contains(constructors[i])) continue;
                nonMatching.add(constructors[i]);
            }
            if (nonMatching.size() > 0) {
                throw new PicoInitializationException("The specified parameters do not match any of the following constructors: " + ((Object)nonMatching).toString() + " for '" + this.getComponentImplementation() + "'");
            }
            throw new PicoInitializationException("There are no public constructors for '" + this.getComponentImplementation() + "'");
        }
        return greediestConstructor;
    }

    private ComponentAdapter getGenericCollectionComponentAdapter(Class componentType) {
        if (this.getContainer().getComponentAdaptersOfType(componentType).size() == 0) {
            return null;
        }
        Object[] componentKey = new Object[]{this, componentType};
        return new GenericCollectionComponentAdapter(componentKey, null, componentType, class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = ConstructorInjectionComponentAdapter.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array);
    }

    protected Object instantiateComponent(List adapterInstantiationOrderTrackingList) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        try {
            Constructor constructor = this.getGreediestSatisifableConstructor(adapterInstantiationOrderTrackingList);
            if (this.instantiating) {
                throw new CyclicDependencyException(constructor.getParameterTypes());
            }
            this.instantiating = true;
            Object[] parameters = this.getConstructorArguments(adapterInstantiationOrderTrackingList);
            Object object = this.newInstance(constructor, parameters);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Should never get here");
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
        finally {
            this.instantiating = false;
        }
    }

    protected Object[] getConstructorArguments(List adapterDependencies) {
        Object[] result = new Object[adapterDependencies.size()];
        for (int i = 0; i < adapterDependencies.size(); ++i) {
            ComponentAdapter adapterDependency = (ComponentAdapter)adapterDependencies.get(i);
            result[i] = adapterDependency.getComponentInstance();
        }
        return result;
    }

    private List getSortedMatchingConstructors() {
        ArrayList matchingConstructors = new ArrayList();
        Constructor<?>[] allConstructors = this.getComponentImplementation().getDeclaredConstructors();
        for (int i = 0; i < allConstructors.length; ++i) {
            Constructor<?> constructor = allConstructors[i];
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            Collections.sort(matchingConstructors, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((Constructor)arg1).getParameterTypes().length - ((Constructor)arg0).getParameterTypes().length;
                }
            });
        }
        return matchingConstructors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

