/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.schema;

import electric.util.Value;
import electric.util.named.IQNamed;
import electric.xml.Element;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.accessors.Accessor;
import electric.xml.io.accessors.IAccessible;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaLocations;
import java.io.IOException;
import java.util.Vector;

public abstract class SchemaEntry
implements IQNamed,
IAccessible,
ISchemaConstants,
IEXMLLoggingConstants {
    protected static String ANONYMOUS_SUFFIX = "_TYPE";
    protected static int DEFAULT_MIN_OCCURS = 1;
    protected boolean useAnonymous = false;
    protected int minOccurs = DEFAULT_MIN_OCCURS;
    protected int maxOccurs = 1;
    protected Schema schema;
    protected String name;
    protected String typeQName;
    protected String refQName;
    protected Type type;
    protected Type parentType;
    protected Accessor accessor;
    static /* synthetic */ Class class$electric$xml$io$schema$SchemaEntry;

    public SchemaEntry(Schema schema, String name, Type type) {
        this.schema = schema;
        this.name = name;
        this.type = type;
    }

    public SchemaEntry(Schema schema) {
        this.schema = schema;
    }

    public SchemaEntry(Type parentType) {
        this.parentType = parentType;
        this.schema = parentType.getSchema();
    }

    public String getNamespace() {
        return this.schema.getTargetNamespace();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getName(Element element) {
        return Type.getName(this.schema.getTargetNamespace(), this.name, element);
    }

    public synchronized Type getType() throws SchemaException {
        if (this.type != null) {
            return this.type;
        }
        if (this.typeQName != null) {
            this.type = this.schema.getNamespaces().getTypeWithQName(this.typeQName);
        } else if (this.refQName != null) {
            this.type = ((SchemaEntry)this.schema.getNamespaces().getItem(this.refQName, class$electric$xml$io$schema$SchemaEntry == null ? (class$electric$xml$io$schema$SchemaEntry = SchemaEntry.class$("electric.xml.io.schema.SchemaEntry")) : class$electric$xml$io$schema$SchemaEntry)).getType();
        }
        return this.type;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public abstract Class getJavaClass() throws SchemaException;

    public abstract String getJavaName() throws SchemaException;

    public Class getAccessibleJavaClass() throws SchemaException {
        return this.parentType.getJavaClass();
    }

    public String getAccessibleJavaName() throws SchemaException {
        return this.getJavaName();
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
        dependencies.addElement(this.getType());
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public boolean isUseAnonymous() {
        return this.useAnonymous;
    }

    public void setUseAnonymous(boolean useAnonymous) {
        this.useAnonymous = useAnonymous;
    }

    public void appendImport(Element element) throws SchemaException {
        if (this.getType().useAnonymous()) {
            return;
        }
        Element schema = element;
        while (schema != null && !schema.getName().equals("schema")) {
            schema = schema.getParentElement();
        }
        if (schema == null) {
            schema = element;
        }
        String targetNamespace = this.getType().getNamespace();
        String schemaTargetNamespace = schema.getAttribute("targetNamespace");
        if (schemaTargetNamespace != null && schemaTargetNamespace.equals(targetNamespace)) {
            return;
        }
        if (schemaTargetNamespace == null && targetNamespace.equals("")) {
            return;
        }
        SchemaLocations.appendImport(schema, targetNamespace, null);
    }

    public static void setAnonymousSuffix(String suffix) {
        ANONYMOUS_SUFFIX = suffix;
    }

    public static int getDefaultMinOccurs() {
        return DEFAULT_MIN_OCCURS;
    }

    public static void setDefaultMinOccurs(int defaultMinOccurs) {
        DEFAULT_MIN_OCCURS = defaultMinOccurs;
    }

    public abstract void writeObject(IWriter var1, Object var2) throws IOException;

    public abstract void readObject(IReader var1, Value var2) throws IOException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

