/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.complex;

import electric.util.classloader.ClassLoaders;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.io.ITypeFactory;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;

public final class ComplexTypeFactory
implements ITypeFactory,
ISchemaConstants {
    public Type newType(Namespaces namespaces, Class javaClass) throws SchemaException {
        String packageName = Strings.getJavaPackage(javaClass.getName());
        String namespace = Mappings.getNamespace(packageName);
        String name = Strings.getLocalJavaName(javaClass.getName());
        return new ComplexType(namespaces.findSchema(namespace), name, javaClass);
    }

    public Type newType(Namespaces namespaces, String namespace, String name, Element schema) throws SchemaException {
        if (!schema.getName().equals("complexType")) {
            return null;
        }
        if (name == null) {
            name = schema.getAttributeValue("name");
        }
        if (name == null) {
            return null;
        }
        return new ComplexType(namespaces.findSchema(namespace), name, schema);
    }

    public Type newType(Namespaces namespaces, String namespace, String name) throws SchemaException {
        String javaName = Mappings.getJavaName(namespace, name);
        if (javaName == null) {
            return null;
        }
        try {
            Class javaClass = ClassLoaders.loadClass(javaName);
            return new ComplexType(namespaces.findSchema(namespace), name, javaClass);
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }
}

