/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.accessors;

import electric.util.Value;
import electric.util.java.JavaSource;
import electric.util.reflect.Accessibility;
import electric.util.reflect.BeanField;
import electric.util.reflect.Reflect;
import electric.xml.Element;
import electric.xml.io.accessors.Accessor;
import electric.xml.io.accessors.FieldAccessor;
import electric.xml.io.accessors.IAccessible;
import electric.xml.io.accessors.MethodAccessor;
import electric.xml.io.accessors.PropertyAccessor;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class UnboundAccessor
extends Accessor {
    private boolean bound;
    private Accessor accessor;
    private String name;
    private String field;
    private String property;
    private String get;
    private String set;

    public UnboundAccessor(IAccessible accessible, String name, Element element) throws SchemaException {
        super(accessible);
        this.name = name;
        String tmeMapNamespace = SchemaProperties.getTmeMap();
        this.field = element.getAttributeValue(tmeMapNamespace, "field");
        if (this.field != null) {
            return;
        }
        this.property = element.getAttributeValue(tmeMapNamespace, "property");
        if (this.property != null) {
            return;
        }
        this.get = element.getAttributeValue(tmeMapNamespace, "get");
        this.set = element.getAttributeValue(tmeMapNamespace, "set");
        if (this.get == null && this.set != null) {
            throw new SchemaException("cannot have a map:set without a map:get {" + accessible.getAccessibleJavaClass() + "}");
        }
    }

    public void set(Value target, Value value) throws Exception {
        Accessor accessor = this.getAccessor(false);
        if (accessor != null) {
            accessor.set(target, value);
        }
    }

    public synchronized Object get(Object target) throws Exception {
        Accessor accessor = this.getAccessor(false);
        return accessor == null ? null : accessor.get(target);
    }

    public synchronized void writeJava(JavaSource source) throws SchemaException {
        this.getAccessor(true).writeJava(source);
    }

    public synchronized void annotateSchema(Element element) throws SchemaException {
        Accessor accessor = this.getAccessor(false);
        if (accessor != null) {
            accessor.annotateSchema(element);
        }
    }

    private synchronized Accessor getAccessor(boolean creating) throws SchemaException {
        if (this.bound) {
            return this.accessor;
        }
        this.bound = true;
        if (this.field != null) {
            this.accessor = new FieldAccessor(this.accessible, this.field);
        } else if (this.property != null) {
            this.accessor = new PropertyAccessor(this.accessible, this.property);
        } else if (this.get != null) {
            this.accessor = new MethodAccessor(this.accessible, this.get, this.set);
        } else if (creating) {
            this.accessor = new FieldAccessor(this.accessible, this.name);
        } else {
            boolean hasAccessibleField;
            block12: {
                hasAccessibleField = true;
                Class javaClass = this.accessible.getAccessibleJavaClass();
                if (javaClass != null) {
                    try {
                        Field javaField = Reflect.getDeclaredField(javaClass, this.name);
                        hasAccessibleField = Accessibility.canSetAccessible() || Modifier.isPublic(javaField.getModifiers());
                    }
                    catch (NoSuchFieldException exception) {
                        hasAccessibleField = false;
                        BeanField beanField = BeanField.getBeanField(javaClass, this.name);
                        if (beanField != null) break block12;
                        return null;
                    }
                }
            }
            this.accessor = hasAccessibleField ? new FieldAccessor(this.accessible, this.name) : new PropertyAccessor(this.accessible, this.name);
        }
        return this.accessor;
    }
}

