/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.accessors;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.java.JavaField;
import electric.util.java.JavaNames;
import electric.util.java.JavaSource;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.Accessibility;
import electric.util.reflect.Reflect;
import electric.util.reflect.Wrappers;
import electric.xml.Element;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.io.accessors.Accessor;
import electric.xml.io.accessors.IAccessible;
import electric.xml.io.accessors.PropertyAccessor;
import electric.xml.io.schema.SchemaException;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class FieldAccessor
extends Accessor {
    private String name;
    private Object NO_CLASSLOADER = new Object();
    private Hashtable classLoaderToField = new Hashtable();

    public FieldAccessor(IAccessible accessible, String name) {
        super(accessible);
        this.name = JavaNames.isJavaIdentifier(name) ? name : JavaNames.getJavaName(name);
    }

    public String toString() {
        return "FieldAccessor( " + this.name + " )";
    }

    public void set(Value target, Value value) throws Exception {
        Object object = value.getObject();
        if (object == null) {
            return;
        }
        Class<?> valueClass = object.getClass();
        if (valueClass.isArray() && ArrayUtil.isPrimitiveArray(object) && !ArrayUtil.isPrimitiveArray(this.getField().getType())) {
            object = Wrappers.convertToWrapperArray(object);
        }
        try {
            this.getField().set(target.object, object);
        }
        catch (IllegalArgumentException exception) {
            String message = "Object " + object + " does not match field " + this.getField() + " on java class " + this.accessible.getAccessibleJavaClass().getName();
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            if (Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
                Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, message, exception);
            }
            throw new SchemaException(message);
        }
        catch (IllegalAccessException exception) {
            String message = "Cannot access field " + this.name + " on java class " + this.accessible.getAccessibleJavaClass().getName();
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            if (Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
                Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, message, exception);
            }
            throw new SchemaException(message);
        }
        catch (NoSuchFieldException exception) {
            String message = "Cannot find field " + this.name + " on java class " + this.accessible.getAccessibleJavaClass().getName();
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            if (Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
                Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, message, exception);
            }
            throw new SchemaException(message);
        }
        catch (SchemaException exception) {
            String message = "Cannot find field " + this.name + " on java class " + this.accessible.getAccessibleJavaClass().getName();
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            if (Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
                Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, message, exception);
            }
            throw exception;
        }
    }

    public Object get(Object target) throws Exception {
        try {
            return this.getField().get(target);
        }
        catch (IllegalAccessException exception) {
            String message = "Cannot access field " + this.name + " on java class " + this.accessible.getAccessibleJavaClass().getName();
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            if (Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
                Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, message, exception);
            }
            throw new SchemaException(message);
        }
        catch (NoSuchFieldException exception) {
            String message = "Cannot find field " + this.name + " on java class " + this.accessible.getAccessibleJavaClass().getName();
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            if (Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
                Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, message, exception);
            }
            throw new SchemaException(message);
        }
        catch (SchemaException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            if (Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
                Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, (Throwable)exception);
            }
            throw exception;
        }
    }

    private synchronized Field getField() throws NoSuchFieldException, SchemaException {
        Field returnField;
        Object key = ClassLoaders.getContextClassLoader();
        if (key == null) {
            key = this.NO_CLASSLOADER;
        }
        if ((returnField = (Field)this.classLoaderToField.get(key)) != null) {
            return returnField;
        }
        returnField = this.getField0();
        if (returnField != null) {
            this.classLoaderToField.put(key, returnField);
        }
        return returnField;
    }

    private Field getField0() throws SchemaException, NoSuchFieldException {
        Class javaClass = this.accessible.getAccessibleJavaClass();
        Field field = Reflect.getDeclaredField(javaClass, this.name);
        if (field == null) {
            throw new SchemaException("could not find field " + this.name + " in java class " + javaClass.getName());
        }
        if (Accessibility.canSetAccessible()) {
            Accessibility.setAccessible(new Field[]{field}, true);
        }
        return field;
    }

    public void annotateSchema(Element element) {
        element.setAttribute("map", "field", this.name);
    }

    public void writeJava(JavaSource source) throws SchemaException {
        if (source.isGenerateAccessors()) {
            new PropertyAccessor(this.accessible, this.name).writeJava(source);
        } else {
            source.addField(new JavaField("public", this.getJavaName(), this.name, null));
        }
    }
}

