/*
 * Decompiled with CFR 0.152.
 */
package electric.util.java;

import electric.util.array.ArrayUtil;
import electric.util.io.Streams;
import electric.util.lex.Lex;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.JavaComment;
import electric.util.reflect.JavaMethod;
import electric.util.string.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class JavaInterface
implements ILoggingConstants {
    private static final String PACKAGE = "package";
    private static final String IMPORT = "import";
    private static final String PUBLIC = "public";
    private static final String INTERFACE = "interface";
    private static final String EXTENDS = "extends";
    private static final String STATIC = "static";
    private static final String ABSTRACT = "abstract";
    private static final String FINAL = "final";
    private static final String THROWS = "throws";
    private static final String EXCEPTION = "exception";
    private static final String PARAM = "param";
    private static final String OPEN_BRACE = "{";
    private static final String CLOSE_BRACE = "}";
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";
    private static final String OPEN_BRACKET = "[";
    private static final String CLOSE_BRACKET = "]";
    private static final String EMPTY_BRACKETS = "[]";
    private static final char OPEN_BRACKET_CHAR = '[';
    private static final String OPEN_PAREN = "(";
    private static final String CLOSE_PAREN = ")";
    private static final char EQUALS_CHAR = '=';
    private static final Hashtable classToJavaInterface = new Hashtable();
    private static final JavaInterface NO_INTERFACE = new JavaInterface();
    private String packageName;
    private String[] imports = new String[0];
    private JavaComment comment;
    private String interfaceName;
    private String[] extendsNames = new String[0];
    private JavaMethod[] methods = new JavaMethod[0];

    public JavaInterface() {
    }

    public JavaInterface(Class type) {
        String name = type.getName();
        this.packageName = Strings.tail(name, '.');
        this.interfaceName = Strings.tail(name, '.');
        if (this.packageName.equals(this.interfaceName)) {
            this.packageName = null;
        }
        Class<?>[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.extendsNames = (String[])ArrayUtil.addElement(this.extendsNames, interfaces[i].getName());
            ++i;
        }
        Method[] array = type.getDeclaredMethods();
        int i2 = 0;
        while (i2 < array.length) {
            this.methods = (JavaMethod[])ArrayUtil.addElement(this.methods, new JavaMethod(array[i2]));
            ++i2;
        }
    }

    public JavaInterface(String source) throws IOException {
        Lex lex = new Lex(source, "{},;", 129);
        String token = lex.readToken();
        if (token.equals(PACKAGE)) {
            this.packageName = lex.readToken();
            lex.readToken(SEMICOLON);
            lex.clearComment();
            token = lex.readToken();
        }
        while (token.equals(IMPORT)) {
            String importName = lex.readToken();
            this.imports = (String[])ArrayUtil.addElement(this.imports, importName);
            lex.readToken(SEMICOLON);
            lex.clearComment();
            token = lex.readToken();
        }
        this.comment = this.newJavaComment(lex.getComment());
        if (!token.equals(PUBLIC)) {
            throw new IOException("keyword public expected");
        }
        lex.readToken(INTERFACE);
        this.interfaceName = lex.readToken();
        token = lex.readToken();
        if (token.equals(EXTENDS)) {
            do {
                String extendsName = lex.readToken();
                this.extendsNames = (String[])ArrayUtil.addElement(this.extendsNames, extendsName);
            } while ((token = lex.readToken()).equals(COMMA));
        }
        if (!token.equals(OPEN_BRACE)) {
            throw new IOException("expected {");
        }
        lex.clearComment();
        token = lex.readToken();
        while (token != null && !token.equals(CLOSE_BRACE)) {
            String declaration = lex.readToPattern(SEMICOLON, 6);
            if (declaration.indexOf(61) == -1) {
                JavaMethod method = this.newJavaMethod(token + declaration, lex.getComment());
                this.methods = (JavaMethod[])ArrayUtil.addElement(this.methods, method);
            }
            lex.clearComment();
            token = lex.readToken();
        }
    }

    private JavaMethod newJavaMethod(String source, String comment) throws IOException {
        Lex lex = new Lex(source, "(),;[]", 1);
        String token = lex.readToken();
        while (token.equals(PUBLIC) || token.equals(STATIC) || token.equals(FINAL) || token.equals(ABSTRACT)) {
            token = lex.readToken();
        }
        String returnType = this.readType(lex, token);
        String name = lex.readToken();
        String[] argTypes = new String[]{};
        String[] argNames = new String[]{};
        lex.readToken(OPEN_PAREN);
        token = lex.readToken();
        while (!token.equals(CLOSE_PAREN)) {
            argTypes = (String[])ArrayUtil.addElement(argTypes, this.readType(lex, token));
            argNames = (String[])ArrayUtil.addElement(argNames, lex.readToken());
            token = lex.readToken();
            if (!token.equals(COMMA)) continue;
            token = lex.readToken();
        }
        token = lex.readToken();
        String[] exceptions = new String[]{};
        if (!token.equals(SEMICOLON)) {
            if (!token.equals(THROWS)) {
                throw new IOException("expected ; or throws");
            }
            token = lex.readToken();
            while (!token.equals(SEMICOLON)) {
                exceptions = (String[])ArrayUtil.addElement(exceptions, token);
                token = lex.readToken();
                if (!token.equals(COMMA)) continue;
                token = lex.readToken();
            }
        }
        JavaComment javaComment = this.newJavaComment(comment);
        return new JavaMethod(name, argTypes, argNames, returnType, exceptions, javaComment);
    }

    private String readType(Lex lex, String token) throws IOException {
        if (token.equals(FINAL)) {
            token = lex.readToken();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(token);
        lex.skipWhitespace();
        int peek = lex.peek();
        while (peek == 91) {
            lex.read();
            lex.readToken(CLOSE_BRACKET);
            buffer.append(EMPTY_BRACKETS);
            lex.skipWhitespace();
            peek = lex.peek();
        }
        return buffer.toString();
    }

    private JavaComment newJavaComment(String string) throws IOException {
        JavaComment comment = new JavaComment();
        if (string.length() == 0) {
            return comment;
        }
        comment.original = string;
        StringTokenizer lines = new StringTokenizer(string, "\n");
        StringBuffer buffer = new StringBuffer();
        String tag = null;
        while (lines.hasMoreElements()) {
            String line = lines.nextToken().trim();
            if (line.startsWith("//")) {
                this.add(line.substring(2).trim(), buffer);
                continue;
            }
            if (line.startsWith("*") && !line.startsWith("*/")) {
                int i = line.indexOf(64, 1);
                if (i != -1 && line.substring(1, i).trim().length() == 0) {
                    this.flush(comment, buffer, tag);
                    buffer = new StringBuffer();
                    Lex lex = new Lex(line.substring(i + 1));
                    tag = lex.readToken();
                    if (tag.equals(PARAM)) {
                        tag = tag + " " + lex.readToken();
                    } else if (tag.equals(THROWS) || tag.equals(EXCEPTION)) {
                        String name = lex.readToken();
                        tag = tag + " " + name;
                    }
                    this.append(lex.readToPattern("\n", 10).trim(), buffer);
                    continue;
                }
                this.append(line.substring(1).trim(), buffer);
                continue;
            }
            this.append(line, buffer);
        }
        this.flush(comment, buffer, tag);
        return comment;
    }

    private void add(String line, StringBuffer buffer) {
        if (line.length() >= 0) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(line);
        }
    }

    private void append(String line, StringBuffer buffer) {
        if (line.startsWith("/**")) {
            line = line.substring(3).trim();
        } else if (line.startsWith("/*")) {
            line = line.substring(2).trim();
        }
        if (line.endsWith("*/")) {
            line = line.substring(0, line.length() - 2).trim();
        }
        this.add(line, buffer);
    }

    private void flush(JavaComment comment, StringBuffer buffer, String tag) {
        if (buffer.length() > 0) {
            if (tag != null) {
                if (comment.tags == null) {
                    comment.tags = new Hashtable();
                }
                comment.tags.put(tag, buffer.toString());
            } else {
                comment.text = buffer.toString();
            }
        }
    }

    public JavaMethod[] getMethods() {
        return this.methods;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public JavaComment getComment() {
        return this.comment;
    }

    public JavaMethod getMethod(Method method) {
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].matches(method)) {
                return this.methods[i];
            }
            ++i;
        }
        return null;
    }

    public static synchronized JavaInterface getInterface(Class type) {
        JavaInterface javaInterface;
        block7: {
            javaInterface = (JavaInterface)classToJavaInterface.get(type);
            if (javaInterface != null) {
                return javaInterface == NO_INTERFACE ? null : javaInterface;
            }
            String source = JavaInterface.getSource(type);
            if (source == null) {
                if (Log.isLogging(ILoggingConstants.SOURCE_EVENT)) {
                    Log.log(ILoggingConstants.SOURCE_EVENT, (Object)("could not find source for " + type.getName()));
                }
            } else {
                try {
                    javaInterface = new JavaInterface(source);
                }
                catch (Exception exception) {
                    if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block7;
                    Log.log(ILoggingConstants.ERROR_EVENT, (Object)("error parsing source of " + type.getName() + " - " + exception.toString()));
                }
            }
        }
        if (javaInterface == null) {
            classToJavaInterface.put(type, NO_INTERFACE);
            return null;
        }
        classToJavaInterface.put(type, javaInterface);
        return javaInterface;
    }

    private static String getSource(Class type) {
        try {
            String filename = "/" + type.getName().replace('.', '/') + ".java";
            InputStream input = type.getResourceAsStream(filename);
            if (input == null) {
                return null;
            }
            byte[] bytes = Streams.readFully(input);
            input.close();
            return new String(bytes);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

