/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import electric.util.array.ByteArray;
import electric.util.io.ISource;
import electric.util.log.Log;
import java.io.IOException;
import java.io.OutputStream;

public final class ArraySource
implements ISource {
    private ByteArray byteArray;
    private long logMask;

    public ArraySource(byte[] buffer, long logMask) {
        this(buffer, logMask, 0, buffer.length);
    }

    public ArraySource(byte[] buffer, long logMask, int offset, int length) {
        this.byteArray = new ByteArray(buffer, offset, length);
        this.logMask = logMask;
    }

    public ArraySource(ByteArray byteArray, long logMask) {
        this.byteArray = byteArray;
        this.logMask = logMask;
    }

    public void write(OutputStream output) throws IOException {
        if (Log.isLogging(this.logMask)) {
            Log.log(this.logMask, (Object)new String(this.byteArray.bytes, this.byteArray.offset, this.byteArray.length));
        }
        output.write(this.byteArray.bytes, this.byteArray.offset, this.byteArray.length);
    }

    public boolean canResend() {
        return true;
    }

    public int getLength() {
        return this.byteArray.length;
    }

    public int getOffset() {
        return this.byteArray.offset;
    }

    public ByteArray getByteArray() {
        return this.byteArray;
    }
}

