/*
 * Decompiled with CFR 0.152.
 */
package electric.util.html;

import electric.util.html.IHTMLConstants;
import electric.xml.Attribute;
import electric.xml.Element;
import electric.xml.Text;

public class HTML
extends Element
implements IHTMLConstants {
    public HTML() {
    }

    public HTML(String name) {
        super(name);
    }

    public static HTML document(String title) {
        Element head = new Element();
        head.setName("head");
        HTML titleHTML = new HTML("title");
        titleHTML.setText(title);
        head.addChild(titleHTML);
        HTML html = new HTML("html");
        html.addChild(head);
        HTML body = new HTML("body");
        html.addChild(body);
        return body;
    }

    public HTML body() {
        return this.newHTML("body");
    }

    public HTML division() {
        return this.newHTML("div");
    }

    public HTML span() {
        return this.newHTML("span");
    }

    public HTML heading(int level) {
        return this.newHTML("h" + level);
    }

    public HTML head() {
        return this.newHTML("head");
    }

    public HTML ruler() {
        return this.newElement("hr");
    }

    public HTML html() {
        return this.newHTML("html");
    }

    public HTML title() {
        return this.newHTML("title");
    }

    public HTML newline() {
        return this.newElement("br");
    }

    public HTML code() {
        return this.newHTML("code");
    }

    public HTML paragraph() {
        return this.newHTML("p");
    }

    public HTML preformatted() {
        return this.newHTML("pre");
    }

    public HTML subscript() {
        return this.newHTML("sub");
    }

    public HTML superscript() {
        return this.newHTML("sup");
    }

    public HTML bold() {
        return this.newHTML("b");
    }

    public HTML big() {
        return this.newHTML("big");
    }

    public HTML font() {
        return this.newHTML("font");
    }

    public HTML italic() {
        return this.newHTML("i");
    }

    public HTML small() {
        return this.newHTML("small");
    }

    public HTML typewriter() {
        return this.newHTML("tt");
    }

    public HTML underline() {
        return this.newHTML("u");
    }

    public HTML bulletList() {
        return this.newHTML("ul");
    }

    public HTML numberList() {
        return this.newHTML("ol");
    }

    public HTML item() {
        return this.newHTML("lI");
    }

    public HTML definitionList() {
        return this.newHTML("dl");
    }

    public HTML definitionKey() {
        return this.newHTML("dt");
    }

    public HTML definitionValue() {
        return this.newHTML("dd");
    }

    public HTML link(String link) {
        HTML element = new HTML("a");
        Attribute attribute = new Attribute("href", link);
        attribute.setRaw(true);
        element.setAttribute(attribute);
        this.addChild(element);
        return element;
    }

    public HTML table() {
        return this.newHTML("table");
    }

    public HTML cols(String columns) {
        return this.newAttribute("cols", columns);
    }

    public HTML cell() {
        return this.newHTML("td");
    }

    public HTML cellHeading() {
        return this.newHTML("th");
    }

    public HTML row() {
        return this.newHTML("tr");
    }

    public HTML frameset() {
        return this.newHTML("frameset");
    }

    public HTML frame() {
        return this.newHTML("frame");
    }

    public HTML image() {
        return this.newHTML("img");
    }

    public HTML style() {
        return this.newHTML("style");
    }

    public HTML styleclass(String styleclass) {
        return this.newAttribute("class", styleclass);
    }

    public HTML form(String method, String action) {
        HTML element = new HTML("form");
        element.setAttribute("method", method);
        element.setAttribute("action", action);
        this.addChild(element);
        return element;
    }

    public HTML hidden(String name, String value) {
        HTML element = new HTML("input");
        element.setAttribute("type", "hidden");
        element.setAttribute("name", name);
        element.setAttribute("value", value);
        this.addChild(element);
        return this;
    }

    public HTML submit(String label) {
        HTML element = new HTML("input");
        element.setAttribute("type", "submit");
        element.setAttribute("value", label);
        this.addChild(element);
        return this;
    }

    public HTML button(String source) {
        HTML element = new HTML("input");
        element.setAttribute("type", "image");
        element.setAttribute("src", source);
        this.addChild(element);
        return this;
    }

    public HTML reset(String label) {
        HTML element = new HTML("input");
        element.setAttribute("type", "reset");
        element.setAttribute("value", label);
        this.addChild(element);
        return this;
    }

    public HTML option(String value, boolean selected, String text) {
        HTML element = new HTML("option");
        element.setText(text);
        element.setAttribute("value", value);
        if (selected) {
            element.setAttribute("selected", "selected");
        }
        this.addChild(element);
        return this;
    }

    public HTML textBox(String name, int size, int maxlength, String text) {
        HTML element = new HTML("input");
        element.setAttribute("type", "text");
        element.setAttribute("name", name);
        element.setAttribute("value", text);
        element.setAttribute("size", Integer.toString(size));
        if (maxlength > 0) {
            element.setAttribute("maxlength", Integer.toString(maxlength));
        }
        this.addChild(element);
        return this;
    }

    public HTML checkbox(String name, boolean checked, String value) {
        HTML element = new HTML("input");
        element.setAttribute("type", "checkbox");
        element.setAttribute("name", name);
        element.setAttribute("value", value);
        if (checked) {
            element.setAttribute("checked", "checked");
        }
        this.addChild(element);
        return this;
    }

    public HTML radio(String name, boolean checked, String value) {
        HTML element = new HTML("input");
        element.setAttribute("type", "radio");
        element.setAttribute("name", name);
        element.setAttribute("value", value);
        if (checked) {
            element.setAttribute("checked", "checked");
        }
        this.addChild(element);
        return this;
    }

    public HTML textArea(String name, int rows, int columns) {
        HTML element = new HTML("textarea");
        element.setAttribute("name", name);
        element.setAttribute("rows", Integer.toString(rows));
        element.setAttribute("cols", Integer.toString(columns));
        this.addChild(element);
        return element;
    }

    public HTML dropMenu(String name) {
        HTML element = new HTML("select");
        element.setAttribute("name", name);
        this.addChild(element);
        return element;
    }

    public HTML scrollMenu(String name, int size, boolean multiple) {
        HTML element = new HTML("select");
        element.setAttribute("name", name);
        element.setAttribute("size", Integer.toString(size));
        if (multiple) {
            element.setAttribute("multiple", "multiple");
        }
        this.addChild(element);
        return element;
    }

    public String asString() {
        return this.getRoot().toString(-1);
    }

    public HTML backgroundColor(String color) {
        return this.newAttribute("bgcolor", color);
    }

    public HTML textColor(String color) {
        return this.newAttribute("text", color);
    }

    public HTML linkColor(String color) {
        return this.newAttribute("link", color);
    }

    public HTML vlinkColor(String color) {
        return this.newAttribute("vlink", color);
    }

    public HTML alinkColor(String color) {
        return this.newAttribute("alink", color);
    }

    public HTML backgroundImage(String image) {
        return this.newAttribute("background", image);
    }

    public HTML raw(String string) {
        Text text = new Text(string);
        text.setRaw(true);
        this.addText(text);
        return this;
    }

    public HTML text(String string) {
        this.addText(string);
        return this;
    }

    public HTML fontColor(String color) {
        return this.newAttribute("color", color);
    }

    public HTML fontSize(int size) {
        return this.newAttribute("size", Integer.toString(size));
    }

    public HTML fontFace(String face) {
        return this.newAttribute("face", face);
    }

    public HTML strike() {
        return this.newHTML("strike");
    }

    public HTML align(String type) {
        return this.newAttribute("align", type);
    }

    public HTML valign(String type) {
        return this.newAttribute("valign", type);
    }

    public HTML stylesheet(String stylesheet) {
        HTML element = new HTML("link");
        element.setAttribute("rel", "stylesheet");
        element.setAttribute("href", stylesheet);
        this.addChild(element);
        return element;
    }

    public HTML source(String source) {
        return this.newAttribute("src", source);
    }

    public HTML alt(String string) {
        return this.newAttribute("alt", string);
    }

    public HTML verticalSpace(String space) {
        return this.newAttribute("vspace", space);
    }

    public HTML horizontalSpace(String space) {
        return this.newAttribute("hspace", space);
    }

    public HTML border(String width) {
        return this.newAttribute("border", width);
    }

    public HTML cellSpacing(String amount) {
        return this.newAttribute("cellspacing", amount);
    }

    public HTML cellPadding(String amount) {
        return this.newAttribute("cellpadding", amount);
    }

    public HTML width(String amount) {
        return this.newAttribute("width", amount);
    }

    public HTML rowSpan(String number) {
        return this.newAttribute("rowspan", number);
    }

    public HTML colSpan(String number) {
        return this.newAttribute("colspan", number);
    }

    public HTML rows(String rows) {
        return this.newAttribute("rows", rows);
    }

    public HTML name(String name) {
        return this.newAttribute("name", name);
    }

    public HTML target(String target) {
        return this.newAttribute("target", target);
    }

    private HTML newHTML(String name) {
        HTML newXML = new HTML(name);
        this.addChild(newXML);
        return newXML;
    }

    private HTML newAttribute(String name, String value) {
        this.setAttribute(name, value);
        return this;
    }

    private HTML newElement(String name) {
        this.addChild(new HTML(name));
        return this;
    }
}

