/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dictionary.sql;

import electric.sql.mapping.ObjectMapper;
import electric.util.WrappedException;
import electric.util.dictionary.DictionaryElements;
import electric.util.dictionary.persistent.IPersistentDictionary;
import electric.util.dictionary.persistent.Sync;
import electric.util.dictionary.sql.RowHandle;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SQLDictionary
extends Dictionary
implements IPersistentDictionary {
    private String tablename;
    private ObjectMapper mapper;
    private Hashtable keyToRowHandle = new Hashtable();
    private boolean sync;

    public SQLDictionary(String tablename, ObjectMapper mapper) {
        this(tablename, mapper, false);
    }

    public SQLDictionary(String tablename, ObjectMapper mapper, boolean delete) {
        this.tablename = tablename;
        this.mapper = mapper;
        try {
            this.initialize(delete);
        }
        catch (SQLException exception) {
            throw new WrappedException(exception);
        }
    }

    private void initialize(boolean delete) throws SQLException {
        if (delete) {
            this.mapper.clearTable(this.tablename);
            return;
        }
        if (!this.mapper.isEmpty(this.tablename)) {
            Enumeration enumeration = this.mapper.getKeys(this.tablename);
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                this.keyToRowHandle.put(key, new RowHandle(this.mapper, this.tablename, key, true));
            }
        }
    }

    public Dictionary getDictionary() {
        return this;
    }

    public int size() {
        return this.keyToRowHandle.size();
    }

    public boolean isEmpty() {
        return this.keyToRowHandle.isEmpty();
    }

    public Enumeration keys() {
        return this.keyToRowHandle.keys();
    }

    public Enumeration elements() {
        return new DictionaryElements(this);
    }

    public Object get(Object key) throws WrappedException {
        RowHandle handle = (RowHandle)this.keyToRowHandle.get(key);
        return handle == null ? null : handle.get();
    }

    public Object put(Object key, Object value) throws IllegalArgumentException, WrappedException {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a string");
        }
        RowHandle handle = (RowHandle)this.keyToRowHandle.get(key);
        if (handle == null) {
            handle = new RowHandle(this.mapper, this.tablename, (String)key, false);
            this.keyToRowHandle.put(key, handle);
        }
        try {
            return handle.put(value);
        }
        catch (SQLException exception) {
            throw new WrappedException(exception);
        }
    }

    public Object remove(Object key) {
        return null;
    }

    public Object load(Object key) {
        RowHandle handle = (RowHandle)this.keyToRowHandle.get(key);
        return handle == null ? null : handle.load();
    }

    public Object peek(Object key) {
        RowHandle handle = (RowHandle)this.keyToRowHandle.get(key);
        return handle == null ? null : handle.peek();
    }

    public void clear() {
        try {
            this.mapper.clearTable(this.tablename);
        }
        catch (SQLException exception) {
            throw new WrappedException(exception);
        }
    }

    public void delete() {
        this.clear();
    }

    public void setSync(boolean flag) {
        if (flag && !this.sync) {
            Sync.addDictionary(this);
        } else if (this.sync && !flag) {
            Sync.removeDictionary(this);
        }
        this.sync = flag;
    }

    public boolean getSync() {
        return this.sync;
    }

    public void sync() {
        RowHandle handle;
        if (!this.sync) {
            return;
        }
        try {
            Enumeration enumeration = this.mapper.getKeys(this.tablename);
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                handle = (RowHandle)this.keyToRowHandle.get(key);
                if (handle != null) continue;
                this.keyToRowHandle.put(key, new RowHandle(this.mapper, this.tablename, key, true));
            }
        }
        catch (SQLException exception) {
            throw new WrappedException(exception);
        }
        Vector<RowHandle> removed = new Vector<RowHandle>();
        Enumeration enumeration = this.keyToRowHandle.elements();
        while (enumeration.hasMoreElements()) {
            handle = (RowHandle)enumeration.nextElement();
            try {
                if (!handle.hasRow() || this.mapper.select(handle.getKey(), this.tablename) != null) continue;
                removed.addElement(handle);
            }
            catch (SQLException exception) {
                throw new WrappedException(exception);
            }
        }
        try {
            Enumeration enumeration2 = removed.elements();
            while (enumeration2.hasMoreElements()) {
                RowHandle handle2 = (RowHandle)enumeration2.nextElement();
                this.keyToRowHandle.remove(handle2.getKey());
                this.mapper.delete(handle2.getKey(), this.tablename);
            }
        }
        catch (SQLException exception) {
            throw new WrappedException(exception);
        }
    }

    public boolean getEncoded() {
        throw new UnsupportedOperationException("underlying storage is not xml");
    }

    public void setEncoded(boolean encoded) {
        throw new UnsupportedOperationException("underlying storage is not xml");
    }
}

