/*
 * Decompiled with CFR 0.152.
 */
package electric.util.classloader;

import electric.util.Context;
import electric.util.io.Streams;
import electric.util.java.VMOptions;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.path.PathUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;

public class ClassLoaders
implements ILoggingConstants {
    private static String CLASSLOADER = "CLASSLOADER";
    static /* synthetic */ Class class$electric$util$classloader$ClassLoaders;

    public static ClassLoader getServletClassLoader() {
        ClassLoader cl = ClassLoaders.getContextClassLoader();
        if (cl == null) {
            cl = (class$electric$util$classloader$ClassLoaders == null ? (class$electric$util$classloader$ClassLoaders = ClassLoaders.class$("electric.util.classloader.ClassLoaders")) : class$electric$util$classloader$ClassLoaders).getClassLoader();
        }
        return cl;
    }

    public static Class loadClass(String className, ClassLoader userClassLoader) throws ClassNotFoundException {
        if (className.startsWith("[")) {
            return Array.newInstance(ClassLoaders.loadClass(className.substring(1), userClassLoader), 0).getClass();
        }
        if (className.endsWith(";")) {
            return ClassLoaders.loadClass(className.substring(1, className.length() - 1), userClassLoader);
        }
        if (userClassLoader == null) {
            userClassLoader = ClassLoaders.getServletClassLoader();
        }
        return userClassLoader != null ? userClassLoader.loadClass(className) : Class.forName(className);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        if (className.startsWith("[")) {
            return Array.newInstance(ClassLoaders.loadClass(className.substring(1)), 0).getClass();
        }
        if (className.endsWith(";")) {
            return ClassLoaders.loadClass(className.substring(1, className.length() - 1));
        }
        ClassLoader contextClassLoader = ClassLoaders.getServletClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader.loadClass(className);
        }
        return Class.forName(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadResource(String path) throws IOException {
        byte[] byArray;
        InputStream input = ClassLoaders.getInputStream(path);
        try {
            byArray = Streams.readFully(input);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return byArray;
    }

    public static InputStream getInputStream(String path) throws IOException {
        if (path.startsWith("file:/")) {
            return ClassLoaders.getInputStreamForFile(path.substring(6));
        }
        return ClassLoaders.getInputStreamForURL(path);
    }

    private static InputStream getInputStreamForFile(String filename) throws IOException {
        String resourceName = filename.replace('\\', '/');
        ClassLoader loader = ClassLoaders.getServletClassLoader();
        InputStream input = null;
        input = loader == null ? ClassLoader.getSystemResourceAsStream(resourceName) : loader.getResourceAsStream(resourceName);
        if (input != null) {
            if (Log.isLogging(ILoggingConstants.RESOURCES_EVENT)) {
                String message = "found in classpath: ";
                message = loader == null ? message + ClassLoader.getSystemResource(resourceName) : message + loader.getResource(resourceName);
                Log.log(ILoggingConstants.RESOURCES_EVENT, (Object)message);
            }
            return input;
        }
        return new FileInputStream(PathUtil.normalizeSlashes(filename));
    }

    private static InputStream getInputStreamForURL(String path) throws IOException {
        return new URL(path).openStream();
    }

    public static ClassLoader getContextClassLoader() {
        if (VMOptions.supportsContextClassLoader()) {
            return Thread.currentThread().getContextClassLoader();
        }
        return ClassLoaders.getCtxtClassLoader();
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        if (VMOptions.supportsContextClassLoader()) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            ClassLoaders.setCtxtClassLoader(classLoader);
        }
    }

    private static ClassLoader getCtxtClassLoader() {
        return (ClassLoader)Context.thread().getProperty(CLASSLOADER);
    }

    private static void setCtxtClassLoader(ClassLoader classLoader) {
        Context.thread().setProperty(CLASSLOADER, classLoader);
    }

    public static boolean isAncestor(ClassLoader ancestor, ClassLoader child) {
        if (ancestor == null) {
            return true;
        }
        if (child == null) {
            return false;
        }
        if (ancestor.equals(child)) {
            return true;
        }
        if (!VMOptions.supportsGetParent()) {
            return false;
        }
        ClassLoader parent = child.getParent();
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean canLoad(ClassLoader loader, Class interfaceClass) {
        try {
            Class<?> newInterfaceClass = loader.loadClass(interfaceClass.getName());
            return interfaceClass.equals(newInterfaceClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

