/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server.sql;

import electric.sql.SQLClient;
import electric.sql.mapping.ITable;
import electric.uddi.Business;
import electric.uddi.Category;
import electric.uddi.Contact;
import electric.uddi.Description;
import electric.uddi.DiscoveryURL;
import electric.uddi.Identifier;
import electric.uddi.Name;
import electric.uddi.Service;
import electric.uddi.UDDIException;
import electric.uddi.server.sql.CategoryTable;
import electric.uddi.server.sql.ContactTable;
import electric.uddi.server.sql.DescriptionTable;
import electric.uddi.server.sql.DiscoveryURLTable;
import electric.uddi.server.sql.IdentifierTable;
import electric.uddi.server.sql.NameTable;
import electric.uddi.server.sql.ServiceTable;
import electric.util.WrappedException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BusinessTable
implements ITable {
    private SQLClient sqlClient;
    private NameTable nameTable;
    private ServiceTable serviceTable;
    private DiscoveryURLTable discoveryTable;
    private DescriptionTable descriptionTable;
    private ContactTable contactTable;
    private IdentifierTable identifierTable;
    private CategoryTable categoryTable;

    public BusinessTable(String databaseName) {
        this.sqlClient = new SQLClient(databaseName);
        this.nameTable = new NameTable(this.sqlClient);
        this.serviceTable = new ServiceTable(this.sqlClient);
        this.discoveryTable = new DiscoveryURLTable(this.sqlClient);
        this.descriptionTable = new DescriptionTable(this.sqlClient);
        this.contactTable = new ContactTable(this.sqlClient);
        this.identifierTable = new IdentifierTable(this.sqlClient);
        this.categoryTable = new CategoryTable(this.sqlClient);
    }

    public void insert(Object value) throws SQLException {
        Business business = (Business)value;
        String businessKey = business.getBusinessKey();
        Name[] names = business.getNames();
        String authorizedName = business.getAuthorizedName();
        String siteOperator = business.getOperator();
        String userName = business.getUserName();
        DiscoveryURL[] discoveryURLs = business.getDiscoveryURLs();
        Description[] descriptions = business.getDescriptions();
        Contact[] contacts = business.getContacts();
        Identifier[] identifiers = business.getIdentifiers();
        Category[] categories = business.getCategories();
        this.insert(businessKey, authorizedName, siteOperator, userName);
        this.nameTable.insert(names, businessKey);
        this.discoveryTable.insert(discoveryURLs, businessKey);
        this.descriptionTable.insert(descriptions, businessKey);
        this.contactTable.insert(contacts, businessKey);
        this.identifierTable.insert(identifiers, businessKey, null);
        this.categoryTable.insert(categories, businessKey, null);
    }

    private void insert(String businessKey, String authorizedName, String siteOperator, String userName) throws SQLException {
        String sql = "INSERT into business (BUSINESS_KEY, AUTHORIZED_NAME, SITE_OPERATOR, USER_NAME) VALUES ('" + businessKey + "','" + authorizedName + "','" + siteOperator + "','" + userName + "')";
        this.sqlClient.insert(sql);
    }

    public Object select(Object key) throws SQLException {
        String businessKey = (String)key;
        Business business = this.selectBusiness(businessKey);
        Service[] services = this.serviceTable.selectServices(businessKey);
        Identifier[] identifiers = this.identifierTable.select(businessKey);
        Name[] names = this.nameTable.select(businessKey);
        Description[] descriptions = this.descriptionTable.select(businessKey);
        business = this.discoveryTable.select(business, businessKey);
        Contact[] contacts = this.contactTable.select(businessKey);
        Category[] categories = this.categoryTable.select(businessKey);
        business.setServices(services);
        business.setNames(names);
        business.setDescriptions(descriptions);
        business.setContacts(contacts);
        business.setIdentifiers(identifiers);
        business.setCategories(categories);
        return business;
    }

    private Business selectBusiness(String businessKey) throws SQLException {
        String query = "SELECT AUTHORIZED_NAME, SITE_OPERATOR, USER_NAME from business where BUSINESS_KEY = '" + businessKey + "'";
        ResultSet rs = this.sqlClient.select(query);
        if (!rs.next()) {
            throw new WrappedException(new UDDIException("business does not exist in UDDI database"));
        }
        String authorizedName = rs.getString(1);
        String siteOperator = rs.getString(2);
        String userName = rs.getString(3);
        Business business = new Business();
        business.setBusinessKey(businessKey);
        business.setAuthorizedName(authorizedName);
        business.setOperator(siteOperator);
        business.setUserName(userName);
        return business;
    }

    public void delete(Object key) throws SQLException {
        String businessKey = (String)key;
        String[] sql = new String[]{"DELETE from business where BUSINESS_KEY = '" + businessKey + "'", "DELETE from name where BUSINESS_KEY = '" + businessKey + "'", "DELETE from discovery_url where BUSINESS_KEY = '" + businessKey + "'", "DELETE from description where DESCRIPTION_KEY = '" + businessKey + "'", "DELETE from identifier where IDENTIFIER_KEY = '" + businessKey + "'", "DELETE from category where CATEGORY_KEY = '" + businessKey + "'"};
        Service[] services = this.serviceTable.selectServices(businessKey);
        this.serviceTable.delete(services);
        this.contactTable.delete(businessKey);
        this.sqlClient.execute(sql);
    }

    public void clear() throws SQLException {
        ResultSet rs = this.sqlClient.select("SELECT BUSINESS_KEY from business");
        while (rs.next()) {
            this.delete(rs.getString(1));
        }
    }
}

