/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.service.descriptor.MethodDescriptor;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPOptimizations;
import electric.soap.wsdl.SOAPOperation;
import electric.soap.wsdl.SOAPOperationFactory;
import electric.soap.wsdl.personality.ISOAPPersonality;
import electric.soap.wsdl.personality.tme.TMESOAPPersonality;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.reflect.IOperation;
import electric.wsdl.Binding;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Operation;
import electric.wsdl.PortType;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.schema.SchemaException;

public class SOAPBinding
extends Binding
implements IWSDLConstants,
ISOAPConstants {
    private static String defaultStyle = "rpc";
    private static ISOAPPersonality defaultWSDLPersonality = new TMESOAPPersonality();
    protected String transport;
    protected String style;
    protected SOAPOperation[] operations = new SOAPOperation[0];
    protected SOAPOptimizations optimizations;
    protected String bindingNamespace = "http://schemas.xmlsoap.org/wsdl/soap/";

    public SOAPBinding(WSDL wsdl, String targetNamespace, Element binding, String bindingNamespace) throws WSDLException, SchemaException {
        super(wsdl, targetNamespace, binding);
        this.bindingNamespace = bindingNamespace;
        Element soap = binding.getElement(bindingNamespace, "binding");
        this.transport = soap.getAttributeValue("transport");
        if (this.transport == null) {
            this.transport = "http://schemas.xmlsoap.org/soap/http";
        }
        this.style = soap.getAttributeValue("style");
        if (this.style == null) {
            this.style = "document";
        }
        Elements operations = binding.getElements("operation");
        while (operations.hasMoreElements()) {
            this.addSOAPOperation(SOAPOperationFactory.getSOAPOperation(this, operations.next()));
        }
        Element optimizationsElement = binding.getElement("optimizations");
        if (optimizationsElement != null) {
            this.optimizations = SOAPOptimizations.getSOAPOptimizations(optimizationsElement);
        }
    }

    public SOAPBinding(WSDL wsdl, String namespace, String name, MethodDescriptor[] methods, Context context) throws WSDLException, SchemaException {
        super(wsdl, namespace, name);
        this.portType = new PortType(namespace, name);
        this.transport = "http://schemas.xmlsoap.org/soap/http";
        this.style = (String)Context.getProperty(context, "style");
        if (this.style == null) {
            this.style = defaultStyle;
        }
        String use = this.style.equalsIgnoreCase("rpc") ? "encoded" : "literal";
        use = (String)context.getProperty("use", use);
        Object operationNamespace = context.getStringProperty("namespace");
        Object action = context.getStringProperty("soapAction");
        Object conextPersonality = Context.getProperty(context, "soapPersonality");
        if (action == null) {
            action = conextPersonality != null ? conextPersonality : defaultWSDLPersonality;
        }
        if (operationNamespace == null) {
            operationNamespace = conextPersonality != null ? conextPersonality : defaultWSDLPersonality;
        }
        int i = 0;
        while (i < methods.length) {
            SOAPOperation operation = SOAPOperationFactory.getSOAPOperation(this, methods, i, operationNamespace, use, action, context);
            this.portType.addOperation(operation.getOperation());
            this.addSOAPOperation(operation);
            ++i;
        }
        this.optimizations = SOAPOptimizations.getServerSideSOAPOptimizations();
    }

    public String toString() {
        return "SOAPBinding( " + this.targetNamespace + ":" + this.name + " )";
    }

    public String getStyle() {
        return this.style;
    }

    public static void setDefaultStyle(String defaultStyle) {
        SOAPBinding.defaultStyle = defaultStyle;
    }

    public static String getDefaultStyle() {
        return defaultStyle;
    }

    public String getTransport() {
        return this.transport;
    }

    protected void addSOAPOperation(SOAPOperation operation) {
        this.operations = (SOAPOperation[])ArrayUtil.addElement(this.operations, operation);
    }

    public SOAPOperation getSOAPOperation(Operation operation) {
        int i = 0;
        while (i < this.operations.length) {
            if (this.operations[i].getOperation() == operation) {
                return this.operations[i];
            }
            ++i;
        }
        return null;
    }

    public SOAPOperation[] getSOAPOperations() {
        return this.operations;
    }

    public IOperation[] getOperations() {
        return this.operations;
    }

    public static String getSOAPResultName(String name) {
        return defaultWSDLPersonality.getSOAPResultName(name);
    }

    public Element writeWSDL(Element definitions) {
        return this.writeWSDLSOAPBinding(definitions);
    }

    protected Element writeWSDLSOAPBinding(Element definitions) {
        Element binding = super.writeWSDL(definitions);
        Element soapBinding = binding.addElement("soap", "binding");
        soapBinding.setAttribute("style", this.style.toLowerCase());
        soapBinding.setAttribute("transport", this.transport);
        if (this.optimizations != null) {
            Element optimizationsElement = binding.addElement("tme", "optimizations");
            this.optimizations.writeSOAPOptimizations(optimizationsElement);
        }
        int i = 0;
        while (i < this.operations.length) {
            this.operations[i].writeWSDL(binding);
            ++i;
        }
        return binding;
    }

    public SOAPOptimizations getOptimizations() {
        return this.optimizations;
    }

    public String getBindingNamespace() {
        return this.bindingNamespace;
    }

    public void setBindingNamespace(String bindingNamespace) {
        this.bindingNamespace = bindingNamespace;
    }

    public static void setDefaultSOAPPersonality(ISOAPPersonality wsdlPersonality) {
        defaultWSDLPersonality = wsdlPersonality;
    }
}

