/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.references.rebind;

import electric.fabric.IFabricConstants;
import electric.http.cookies.ClientCookies;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.references.ISOAPReference;
import electric.soap.references.rebind.RebindSOAPReferenceFactory;
import electric.util.Context;
import electric.util.XURL;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import java.rmi.RemoteException;

public final class RebindSOAPReference
implements ISOAPReference,
IFabricConstants {
    private XURL path;
    private Context proxyContext;
    private RebindSOAPReferenceFactory factory;
    private ISOAPReference reference;

    public RebindSOAPReference(XURL path, Context proxyContext, RebindSOAPReferenceFactory factory, ISOAPReference reference) {
        this.path = path;
        this.proxyContext = proxyContext;
        this.factory = factory;
        this.reference = reference;
    }

    public String toString() {
        return "RebindSOAPReference( " + this.reference + ", path=" + this.path + " )";
    }

    public ISOAPReference getReference() {
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        while (true) {
            try {
                RebindSOAPReference rebindSOAPReference = this;
                synchronized (rebindSOAPReference) {
                    if (this.reference == null) {
                        this.bind();
                    }
                }
                SOAPMessage response = this.reference.handle(request, messageContext);
                if (response.isException()) {
                    SOAPException soapException = response.getSOAPException();
                    String faultString = soapException.getMessage();
                    if (faultString != null && faultString.startsWith("url = ")) {
                        throw new RemoteException("SOAP message indicates " + faultString);
                    }
                    String faultCode = soapException.getSOAPCode();
                }
                return response;
            }
            catch (RemoteException exception) {
                if (this.reference != null) {
                    this.rebind(exception);
                    continue;
                }
                throw exception;
            }
            catch (SecurityException exception) {
                throw exception;
            }
            break;
        }
        catch (RuntimeException exception) {
            throw exception;
        }
    }

    public WSDL getWSDL() {
        return this.reference.getWSDL();
    }

    public XURL getEndpoint() {
        return this.reference.getEndpoint();
    }

    private void bind() throws RemoteException {
        if (Log.isLogging(IFabricConstants.FAILOVER_EVENT)) {
            Log.log(IFabricConstants.FAILOVER_EVENT, (Object)("bind to " + this.path));
        }
        this.reference = this.factory.getSOAPReference(this.path, null, this.proxyContext);
        if (this.reference == null) {
            throw new RemoteException("could not bind to " + this.path);
        }
    }

    private void rebind(Exception exception) throws RemoteException {
        if (Log.isLogging(IFabricConstants.FAILOVER_EVENT)) {
            Log.log(IFabricConstants.FAILOVER_EVENT, (Object)("rebind to " + this.path));
        }
        ClientCookies.removeCookieHolders(this.proxyContext);
        this.reference = this.factory.getSOAPReference(this.path, null, this.proxyContext);
        if (this.reference == null) {
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw new RemoteException(exception.toString());
        }
    }
}

