/*
 * Decompiled with CFR 0.152.
 */
package electric.server.http.detectors.weblogic;

import electric.server.http.IServerURLDetector;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import weblogic.servlet.internal.ServletStubImpl;

public class WebLogicURLDetector
implements IServerURLDetector,
ILoggingConstants {
    private static final String ADMIN = "weblogic.management.Admin";
    private static final String HTTP_URL_METHOD = "getAdminHttpUrl";
    private Method method;

    public WebLogicURLDetector() {
        block2: {
            this.method = null;
            try {
                Class adminClass = ClassLoaders.loadClass(ADMIN);
                this.method = adminClass.getMethod(HTTP_URL_METHOD, new Class[0]);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "Cannot find WebLogic classes. GLUE will not know it's server address until after the first invocation.", throwable);
            }
        }
    }

    public String getURL(ServletConfig config) {
        if (this.method == null) {
            return null;
        }
        try {
            String adminUrl = (String)this.method.invoke(null, new Object[0]);
            if (adminUrl == null) {
                return null;
            }
            if (!(config instanceof ServletStubImpl)) {
                return null;
            }
            String contextPath = ((ServletStubImpl)config).getContextPath();
            String servletPath = ((ServletStubImpl)config).getServletPath();
            adminUrl = Strings.splice(adminUrl, contextPath);
            adminUrl = Strings.splice(adminUrl, servletPath);
            return adminUrl;
        }
        catch (Throwable throwable) {
            block5: {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "Cannot invoke WebLogic Methods. GLUE will not know it's server address until after the first invocation.", throwable);
            }
            return null;
        }
    }
}

