/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.pro.config.AutoJoinConfig;
import electric.glue.pro.config.ConsoleConfig;
import electric.glue.pro.config.IConfigConstants;
import electric.glue.pro.config.InstrumentationConfig;
import electric.glue.pro.config.JMSConfig;
import electric.glue.pro.config.SOAPOptimizationsConfig;
import electric.glue.pro.config.SQLConfig;
import electric.glue.pro.config.WSSecurityConfig;
import electric.glue.pro.config.XMLCanonicalizationConfig;
import electric.glue.pro.config.XMLEncryptionConfig;
import electric.glue.pro.config.XMLSignatureConfig;
import electric.net.socket.SocketServer;
import electric.util.license.Enabler;
import electric.util.license.LicenseInfo;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.ProductConfig;
import electric.util.thread.Tasks;
import electric.xml.Element;

public class Config
extends ProductConfig
implements IConfigConstants,
IGLUELoggingConstants,
Runnable {
    private static final int ID = 2;
    private static final int MAJOR = 5;
    private static final int MINOR = 0;
    private static final int PATCH = 0;

    public Config() {
        super("Glue Professional", 2, 5, 0, 0);
    }

    public Config(String name, int id, int major, int minor, int patch) {
        super(name, id, major, minor, patch);
    }

    public void configure(Element config) throws Throwable {
        this.enableSubSystems();
        new InstrumentationConfig().config(config);
        new SQLConfig().config(config);
        new electric.glue.std.config.Config().configure(config);
        new SOAPOptimizationsConfig().config(config);
        new JMSConfig().config(config);
        new XMLCanonicalizationConfig().config(config);
        new XMLSignatureConfig().config(config);
        new XMLEncryptionConfig().config(config);
        new WSSecurityConfig().config(config);
        new AutoJoinConfig().config(config);
    }

    public void configureAsServer(Element config, Object application) throws Throwable {
        new electric.glue.std.config.Config().configureAsServer(config, application);
        new ConsoleConfig().config(config.getRoot(), application == null);
        ConsoleConfig.addConsoleModule("Glue Professional");
    }

    private void enableSubSystems() throws Exception {
        int i = 0;
        while (i < IConfigConstants.PRO_SUBSYSTEMS.length) {
            Enabler.enableFeature(IConfigConstants.PRO_SUBSYSTEMS[i], this);
            ++i;
        }
    }

    private void disableSubSystems() {
        int i = 0;
        while (i < IConfigConstants.PRO_SUBSYSTEMS.length) {
            Enabler.disableFeature(IConfigConstants.PRO_SUBSYSTEMS[i]);
            ++i;
        }
    }

    public void run() {
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"disabling GLUE professional features");
        this.disableSubSystems();
    }

    public void executeLicenseConstraints() {
        LicenseInfo licenseInfo = this.getProductInfo().getLicenseInfo();
        Integer connLimit = (Integer)licenseInfo.getProperty("connectionLimit");
        SocketServer.setConnectionLimit(connLimit);
        Integer proFeaturesTimeout = (Integer)licenseInfo.getProperty("featureTimeout");
        if (proFeaturesTimeout != null) {
            Log.startLogging(ILoggingConstants.STARTUP_EVENT);
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)(this.getProductInfo().getName() + " features will timeout in " + proFeaturesTimeout + " minutes"));
            Tasks.getShared().runAfter(this, proFeaturesTimeout * 60000);
        }
    }
}

