/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.enterprise.console.services;

import electric.application.ServicesSummary;
import electric.cluster.IClusteredApplication;
import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.glue.context.ProxyContext;
import electric.glue.enterprise.console.services.IClustersServicesConstants;
import electric.glue.pro.console.services.IServicesConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.service.descriptor.ServiceDescriptor;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPOperation;
import electric.util.Context;
import electric.util.java.JavaNames;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import electric.wsdl.parser.WSDLParser;
import electric.xml.Document;
import electric.xml.Element;
import java.util.Hashtable;

public class Services
implements IConsoleModule,
ILoggingConstants,
IConsoleConstants,
IClustersServicesConstants,
IServicesConstants {
    private ConsoleModuleInfo moduleInfo;
    static /* synthetic */ Class class$electric$cluster$IClusteredApplication;
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPBinding;

    public Document getServicesInfo(Hashtable args) {
        Document doc;
        block2: {
            String appName = (String)args.get("applicationName");
            doc = new Document();
            try {
                IClusteredApplication application = this.getApplication(appName);
                Element root = doc.setRoot("DataUpdate");
                Element services = root.addElement("Services");
                ServicesSummary summary = application.getServicesSummary();
                int totalServices = summary.javaObjectServices + summary.ejbObjectServices + summary.virtualObjectServices;
                services.setText("Total", totalServices + "");
                services.setText("DisabledServices", summary.disabledServices + "");
                services.setText("JavaServices", summary.javaObjectServices + "");
                services.setText("EJB", summary.ejbObjectServices + "");
                services.setText("Virtual", summary.virtualObjectServices + "");
                services.setText("TotalApplication", summary.applicationActivation + "");
                services.setText("TotalSession", summary.sessionActivation + "");
                services.setText("TotalRequest", summary.requestActivation + "");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to create services summary", exception);
            }
        }
        return doc;
    }

    private IClusteredApplication getApplication(String appName) throws RegistryException {
        ProxyContext context = new ProxyContext();
        context.setProperty("service.appName", appName);
        return (IClusteredApplication)Registry.bind(class$electric$cluster$IClusteredApplication == null ? (class$electric$cluster$IClusteredApplication = Services.class$("electric.cluster.IClusteredApplication")) : class$electric$cluster$IClusteredApplication, (Context)context);
    }

    public Document getServiceInfo(Hashtable args) {
        String appName = (String)args.get("applicationName");
        String servicePath = (String)args.get("servicePath");
        try {
            IClusteredApplication application = this.getApplication(appName);
            ServiceDescriptor serviceDescriptor = application.getServiceDescriptor(servicePath);
            Document doc = new Document(new Element("ServiceDetails"));
            Element root = doc.getRoot();
            if (serviceDescriptor == null) {
                root.setText("status", "disabled");
            } else {
                root.setText("activation", serviceDescriptor.activation);
                root.setText("status", "enabled");
                root.setText("style", serviceDescriptor.style);
                root.setText("wsdlTargetNamespace", serviceDescriptor.targetNamespace);
                root.setText("methodNamespace", serviceDescriptor.namespace);
                root.setText("description", serviceDescriptor.description);
                root.setText("soapAction", serviceDescriptor.soapAction);
                WSDL wsdl = WSDLParser.newWSDL(serviceDescriptor.endpoint + ".wsdl", new Context());
                this.addMethods(root, wsdl);
            }
            return doc;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to create service summary for " + servicePath, exception);
            }
            return new Document();
        }
    }

    private void addMethods(Element root, WSDL wsdl) throws Exception {
        Element methods = root.addElement("methods");
        SOAPOperation[] operations = ((SOAPBinding)wsdl.getBindings(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = Services.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding)[0]).getSOAPOperations();
        int i = 0;
        while (i < operations.length) {
            SOAPOperation operation = operations[i];
            String methodName = operation.getOperation().getName();
            String documentation = operation.getOperation().getDocumentation();
            Element method = methods.addElement("method");
            method.setText("name", methodName);
            method.setText("description", documentation);
            method.setText("soapAction", operation.getSOAPAction());
            if (operation.parameters.length != 0) {
                int k = 0;
                while (k < operation.parameters.length) {
                    Element argument = method.addElement("argument");
                    String name = operation.parameters[k].getName();
                    String javaName = JavaNames.getShortJavaName(operation.parameters[k].getJavaClass());
                    argument.setText("name", name);
                    argument.setText("javaName", javaName);
                    ++k;
                }
            }
            ++i;
        }
    }

    public Document publishService(Hashtable args) {
        return new Document();
    }

    public String unpublishService(Hashtable args) {
        return null;
    }

    public String handleInvoke(Hashtable arg) {
        return null;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

