/*
 * Decompiled with CFR 0.152.
 */
package electric.getpost.wsdl;

import electric.getpost.wsdl.HTTPOperation;
import electric.util.array.ArrayUtil;
import electric.wsdl.Binding;
import electric.wsdl.Operation;
import electric.wsdl.PortType;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.schema.SchemaException;
import java.lang.reflect.Method;

public final class HTTPBinding
extends Binding {
    private boolean get;
    private HTTPOperation[] httpOperations = new HTTPOperation[0];

    public HTTPBinding(WSDL wsdl, String targetNamespace, Element binding) throws WSDLException, SchemaException {
        super(wsdl, targetNamespace, binding);
        Element http = binding.getElement("http://schemas.xmlsoap.org/wsdl/http/", "binding");
        String verb = http.getAttributeValue("verb");
        if (verb == null) {
            throw new WSDLException("HTTP <binding> is missing verb attribute");
        }
        this.get = "GET".equalsIgnoreCase(verb);
        Elements operations = binding.getElements("operation");
        while (operations.hasMoreElements()) {
            this.addHTTPOperation(new HTTPOperation(this, operations.next()));
        }
    }

    public HTTPBinding(WSDL wsdl, String namespace, String name, Method[] methods, boolean get, String suffix) throws WSDLException, SchemaException {
        super(wsdl, namespace, name + suffix);
        this.portType = new PortType(namespace, name + suffix);
        this.get = get;
        int i = 0;
        while (i < methods.length) {
            HTTPOperation httpOperation = new HTTPOperation(this, methods[i], i, suffix);
            this.portType.addOperation(httpOperation.getOperation());
            this.addHTTPOperation(httpOperation);
            ++i;
        }
    }

    public String toString() {
        return "HTTPBinding( " + this.targetNamespace + ":" + this.name + " )";
    }

    public boolean isGet() {
        return this.get;
    }

    public String getVerb() {
        return this.get ? "GET" : "POST";
    }

    private void addHTTPOperation(HTTPOperation httpOperation) {
        this.httpOperations = (HTTPOperation[])ArrayUtil.addElement(this.httpOperations, httpOperation);
    }

    HTTPOperation getHTTPOperation(Operation operation) {
        int i = 0;
        while (i < this.httpOperations.length) {
            if (this.httpOperations[i].getOperation() == operation) {
                return this.httpOperations[i];
            }
            ++i;
        }
        return null;
    }

    public Element writeWSDL(Element definitions) {
        Element binding = super.writeWSDL(definitions);
        Element httpBinding = binding.addElement("http", "binding");
        httpBinding.setAttribute("verb", this.getVerb());
        int i = 0;
        while (i < this.httpOperations.length) {
            this.httpOperations[i].writeWSDL(binding);
            ++i;
        }
        return binding;
    }
}

