/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.fabric.Fabric;
import electric.fabric.console.services.INodesConstants;
import electric.fabric.console.services.URLComparator;
import electric.fabric.nodes.NodeInfo;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.sorting.BubbleSort;
import electric.xml.Document;
import electric.xml.Element;
import java.util.Hashtable;

public class Nodes
implements ILoggingConstants,
IConsoleModule,
ITreeViewProducer,
INodesConstants,
IConsoleConstants {
    private ConsoleModuleInfo moduleInfo;

    public Document getNodeSummary() {
        try {
            int nodeCount = Fabric.getNodeManager().getNodeCount();
            Document doc = new Document();
            Element root = doc.setRoot("NodeSummary");
            root.setInt("numberNodes", nodeCount);
            return doc;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to get node summary", exception);
            }
            return new Document();
        }
    }

    public Document getNodeList(Hashtable args) {
        String offline = (String)args.get("offline");
        try {
            boolean includeOffline = offline.equalsIgnoreCase("true");
            Object[] nodeData = Fabric.getNodeManager().getAllNodeInfo(includeOffline);
            BubbleSort.sort(nodeData, new URLComparator());
            Document doc = new Document();
            Element root = doc.setRoot("NodeList");
            Element nodesElement = root.addElement("nodes");
            int i = 0;
            while (i < nodeData.length) {
                Element node = nodesElement.addElement("node");
                node.setString("host", ((NodeInfo)nodeData[i]).getURL());
                node.setBoolean("online", ((NodeInfo)nodeData[i]).isOnline());
                ++i;
            }
            return doc;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to get the node list for ", exception);
            }
            return new Document();
        }
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("GaiaNodes");
        element.setAttribute("Name", "Nodes");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "Nodes");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }
}

