/*
 * Decompiled with CFR 0.152.
 */
package electric.console.util;

import electric.console.IConsoleConstants;
import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.Element;
import electric.xml.IXMLConstants;
import electric.xml.Node;
import electric.xml.NodeWriter;
import electric.xml.Text;
import java.io.IOException;
import java.io.Writer;

public class ConsoleNodeWriter
extends NodeWriter
implements IXMLConstants,
IConsoleConstants {
    public ConsoleNodeWriter(Writer writer, int indent, boolean expandEmptyElements, int step, String eol) {
        super(writer, indent, expandEmptyElements, step, eol);
    }

    public void write(Node node) throws IOException {
        if (node instanceof Element) {
            this.writeElement((Element)node);
        } else if (node instanceof Attribute) {
            this.writeAttribute((Attribute)node);
        } else if (node instanceof Text) {
            this.writeText((Text)node);
        } else {
            node.write(this);
        }
    }

    private void writeText(Text text) throws IOException {
        this.write("<B>");
        this.write(text.getString());
        this.write("</B>");
    }

    private void writeAttribute(Attribute attribute) throws IOException {
        this.write("<font color='#FF0000'> ");
        this.write(attribute.getName());
        this.write("</font>");
        this.write("<font color='#0000FF'>");
        this.write("='");
        String value = attribute.getValue();
        if (value == null) {
            this.write("null");
        } else if (attribute.getRaw()) {
            this.write(value);
        } else {
            Text.writeWithSubstitution(this, value);
        }
        this.write('\'');
        this.write("</font>");
    }

    private void writeElement(Element element) throws IOException {
        this.writeIndent();
        this.write("&lt;<font color='#800000'>");
        String prefix = element.getPrefix();
        if (prefix != null && !prefix.equals("")) {
            this.write(prefix);
            this.write(':');
        }
        this.write(element.getName());
        this.write("</font>");
        Attributes attributes = element.getAttributeObjects();
        while (attributes.hasMoreElements()) {
            this.write(' ');
            this.write(attributes.next());
        }
        if (element.hasChildren()) {
            this.write(">");
            element.writeChildren(this);
            this.write("&lt;<font color='#800000'>");
            if (prefix != null && !prefix.equals("")) {
                this.write(prefix);
                this.write(':');
            }
            this.write(element.getName());
            this.write("</font>");
            this.write(">");
        } else {
            this.write("/>");
        }
    }
}

