/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.managed;

import electric.application.web.IStateConstants;
import electric.application.web.WebApplication;
import electric.application.web.managed.ObjectManager;
import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ThreadContext;
import electric.util.classloader.TrackingClassLoader;
import java.io.File;
import java.util.Vector;

public abstract class ManagedObject
implements IStateConstants,
IGLUELoggingConstants,
IGLUEContextConstants {
    private static final ClassLoader[] NO_CLASSLOADERS = new ClassLoader[0];
    private int state = 4;
    private ObjectManager objectManager;
    private ClassLoader classLoader;
    private ClassLoader[] classLoaders;

    protected ManagedObject(ObjectManager objectManager) {
        this.objectManager = objectManager;
    }

    public WebApplication getApplication() {
        return this.objectManager.getApplication();
    }

    public String getAppName() {
        return this.getApplication().getAppName();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public abstract void begin() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        if (this.state == 3) {
            return;
        }
        this.state = 4;
        this.classLoaders = NO_CLASSLOADERS;
        Vector loaders = new Vector();
        ThreadContext.setProperty("classloaders", loaders);
        try {
            try {
                this.begin();
                this.classLoaders = new ClassLoader[loaders.size()];
                loaders.copyInto(this.classLoaders);
                this.state = 3;
            }
            catch (Throwable exception) {
                this.state = 5;
                Object var4_3 = null;
                ThreadContext.removeProperty("classloaders");
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ThreadContext.removeProperty("classloaders");
            throw throwable;
        }
        ThreadContext.removeProperty("classloaders");
    }

    public void startIfInState(int state) {
        if (this.state == state) {
            this.start();
        }
    }

    public abstract void end() throws Throwable;

    public void stop() {
        if (this.state == 4) {
            return;
        }
        try {
            this.end();
            this.state = 4;
        }
        catch (Throwable exception) {
            this.state = 5;
        }
    }

    public void restart() {
        this.start();
        this.stop();
    }

    public boolean usesFiles(File[] files) {
        if (this.classLoaders == null) {
            return false;
        }
        int i = 0;
        while (i < this.classLoaders.length) {
            ClassLoader loader = this.classLoaders[i];
            if (loader instanceof TrackingClassLoader && ((TrackingClassLoader)loader).usesFiles(files)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

