/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import sun.security.action.GetPropertyAction;

public class LogLayout
extends Layout {
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    public String format(LoggingEvent loggingEvent) {
        StringBuffer sb = new StringBuffer();
        if (loggingEvent.getLevel().toInt() > Level.INFO.toInt()) {
            sb.append(loggingEvent.getLevel().toString());
            sb.append(" ");
            if (loggingEvent.getLocationInformation().getClassName() != null) {
                String className = loggingEvent.getLocationInformation().getClassName();
                className = className.substring(7);
                sb.append(className);
            } else {
                sb.append(loggingEvent.getLoggerName());
            }
            if (loggingEvent.getLocationInformation().getMethodName() != null) {
                sb.append(" ");
                sb.append(loggingEvent.getLocationInformation().getMethodName());
            }
            sb.append("(): ");
        }
        String message = loggingEvent.getRenderedMessage();
        sb.append(message);
        sb.append(this.lineSeparator);
        if (loggingEvent.getThrowableInformation() != null && loggingEvent.getThrowableInformation().getThrowable() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                loggingEvent.getThrowableInformation().getThrowable().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                System.err.println("Error formatting logmessage! " + ex.toString());
            }
        }
        return sb.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }
}

