/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.HTMLTagger;
import net.sf.statcvs.renderer.TableCellRenderer;

public class HTMLTableCellRenderer
implements TableCellRenderer {
    private String html = null;

    public void renderCell(String content) {
        this.html = content;
    }

    public void renderEmptyCell() {
        this.html = null;
    }

    public void renderIntegerCell(int value) {
        this.html = Integer.toString(value);
    }

    public void renderIntegerCell(int value, int total) {
        this.html = Integer.toString(value) + " (" + this.getPercentage((double)value / (double)total) + ")";
    }

    public void renderPercentageCell(double ratio) {
        this.html = this.getPercentage(ratio);
    }

    public void renderAuthorCell(Author author) {
        this.html = HTMLTagger.getAuthorLink(author);
    }

    public void renderDirectoryCell(Directory directory) {
        this.html = HTMLTagger.getDirectoryLink(directory);
    }

    public void renderFileCell(CvsFile file, boolean withIcon) {
        this.html = HTMLTagger.getFileLink(file);
        if (withIcon) {
            this.html = file.isDead() ? HTMLTagger.getIcon("file-deleted.png") + " " + this.html : HTMLTagger.getIcon("file.png") + " " + this.html;
        }
    }

    public String getColumnHead() {
        return this.getHtml("th");
    }

    public String getRowHead() {
        return this.getHtml("th");
    }

    public String getTableCell() {
        return this.getHtml("td");
    }

    private String getPercentage(double ratio) {
        if (Double.isNaN(ratio)) {
            return "-";
        }
        int percentTimes10 = (int)Math.round(ratio * 1000.0);
        double percent = (double)percentTimes10 / 10.0;
        return Double.toString(percent) + "%";
    }

    private String getHtml(String tag) {
        if (this.html == null) {
            return "<" + tag + "></" + tag + ">";
        }
        return "<" + tag + ">" + this.html + "</" + tag + ">";
    }
}

