/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.IOException;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.output.HTMLPage;
import net.sf.statcvs.output.HTMLTagger;

public class LOCPage
extends HTMLPage {
    private boolean locImageCreated;

    public LOCPage(CvsContent content, boolean locImageCreated) throws IOException {
        super(content);
        this.locImageCreated = locImageCreated;
        this.setFileName("loc.html");
        this.setPageName(Messages.getString("LOC_TITLE"));
        this.createPage();
    }

    protected void printBody() throws IOException {
        this.printBackLink();
        this.print(this.getLOCImage());
    }

    private String getLOCImage() {
        if (!this.locImageCreated) {
            return this.p(Messages.getString("NO_LOC_AVAILABLE"));
        }
        int loc = this.getContent().getCurrentLOC();
        String result = this.img("loc.png", 640, 480) + this.br() + this.strong(Messages.getString("TOTAL_LOC") + ": ") + loc;
        result = result + " (" + HTMLTagger.getDateAndTime(this.getContent().getLastDate()) + ")";
        return this.p(result);
    }
}

