/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.util.configuration.TraceCarol;
import org.objectweb.jeremie.libs.binding.moa.UnicastRemoteObject;
import org.objectweb.jeremie.libs.services.registry.LocateRegistry;

public class JeremieRegistry
implements NameService {
    public int port = 12340;
    public Registry registry = null;

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JeremieRegistry.start() on port:" + this.port);
        }
        try {
            if (!this.isStarted()) {
                if (this.port >= 0) {
                    this.registry = LocateRegistry.createRegistry((int)this.port);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                JeremieRegistry.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("JeremieRegistry ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start JeremieRegistry, port=" + this.port + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("JeremieRegistry is already start on port:" + this.port);
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not start jeremie registry: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JeremieRegistry.stop()");
        }
        try {
            if (this.registry != null) {
                UnicastRemoteObject.unexportObject((Remote)this.registry, (boolean)true);
            }
            this.registry = null;
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop jeremie registry: " + e);
        }
    }

    public boolean isStarted() {
        if (this.registry != null) {
            return true;
        }
        try {
            LocateRegistry.getRegistry((int)this.port).list();
        }
        catch (RemoteException re) {
            return false;
        }
        return true;
    }

    public void setPort(int p) {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JeremieRegistry.setPort(" + p + ")");
        }
        if (p != 0) {
            this.port = p;
        }
    }

    public int getPort() {
        return this.port;
    }
}

