/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.engine;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPEnvelope;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelParam;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.engine.GenericAsyncEngine;
import org.ofbiz.core.util.Debug;
import org.xml.sax.SAXException;

public final class SOAPClientEngine
extends GenericAsyncEngine {
    public static final String module = SOAPClientEngine.class.getName();

    public SOAPClientEngine(ServiceDispatcher dispatcher) {
        super(dispatcher);
    }

    public void runSyncIgnore(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Map result = this.runSync(localName, modelService, context);
    }

    public Map runSync(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Object result = this.serviceInvoker(localName, modelService, context);
        if (result == null) {
            throw new GenericServiceException("Service did not return expected result");
        }
        if (!(result instanceof Map)) {
            HashMap<String, Object> newResult = new HashMap<String, Object>();
            newResult.put("result", result);
            return newResult;
        }
        return (Map)result;
    }

    private Object serviceInvoker(String localName, ModelService modelService, Map context) throws GenericServiceException {
        if (modelService.location == null || modelService.invoke == null) {
            throw new GenericServiceException("Cannot locate service to invoke");
        }
        Service service = null;
        Call call = null;
        try {
            service = new Service();
            call = (Call)service.createCall();
        }
        catch (JAXRPCException e) {
            throw new GenericServiceException("RPC service error", e);
        }
        catch (ServiceException e) {
            throw new GenericServiceException("RPC service error", e);
        }
        URL endPoint = null;
        try {
            endPoint = new URL(modelService.location);
        }
        catch (MalformedURLException e) {
            throw new GenericServiceException("Location not a valid URL", e);
        }
        List inModelParamList = modelService.getInModelParamList();
        Object[] params = new Object[inModelParamList.size()];
        if (Debug.infoOn()) {
            Debug.logInfo((String)("[SOAPClientEngine.invoke] : Parameter length - " + params.length), (String)module);
        }
        call.setTargetEndpointAddress(endPoint);
        if (!"".equals(modelService.nameSpace)) {
            call.setOperationName(new QName(modelService.nameSpace, modelService.invoke));
        } else {
            call.setOperationName(modelService.invoke);
        }
        Iterator iter = inModelParamList.iterator();
        int i = 0;
        Vector vParams = new Vector();
        while (iter.hasNext()) {
            ModelParam p = (ModelParam)iter.next();
            if (Debug.infoOn()) {
                Debug.logInfo((String)("[SOAPClientEngine.invoke} : Parameter: " + p.name + " (" + p.mode + ") - " + i), (String)module);
            }
            if (!p.name.trim().equals("userLogin") && !p.name.trim().equals("locale")) {
                QName qName = call.getParameterTypeByName(p.name);
                call.addParameter(p.name, qName, this.getMode(p.mode));
                vParams.add(context.get(p.name));
            }
            params[i] = context.get(p.name);
            ++i;
        }
        call.setReturnType(XMLType.XSD_ANYTYPE);
        params = vParams.toArray();
        Object result = null;
        try {
            Debug.logInfo((String)"[SOAPClientEngine.invoke] : Sending Call To SOAP Server", (String)module);
            result = call.invoke(params);
        }
        catch (RemoteException e) {
            throw new GenericServiceException("RPC error", e);
        }
        return this.getResponseParams(call.getMessageContext().getResponseMessage());
    }

    private Map getResponseParams(Message respMessage) {
        Hashtable<String, Object> mRet = new Hashtable<String, Object>();
        try {
            SOAPEnvelope resEnv = respMessage.getSOAPEnvelope();
            Vector bodies = resEnv.getBodyElements();
            for (Object o : bodies) {
                if (!(o instanceof RPCElement)) continue;
                RPCElement body = (RPCElement)o;
                String serviceName = body.getMethodName();
                Vector params = null;
                params = body.getParams();
                HashMap serviceContext = new HashMap();
                for (RPCParam param : params) {
                    mRet.put(param.getName(), param.getValue());
                    System.out.println(param.getName() + "=" + param.getValue());
                }
            }
        }
        catch (AxisFault e) {
            System.out.println("AxisFault:" + e.toString());
        }
        catch (SAXException e) {
            System.out.println("SAXException:" + e.toString());
        }
        return mRet;
    }

    private ParameterMode getMode(String sMode) {
        if (sMode.equals("IN")) {
            return ParameterMode.IN;
        }
        if (sMode.equals("OUT")) {
            return ParameterMode.OUT;
        }
        if (sMode.equals("INOUT")) {
            return ParameterMode.INOUT;
        }
        return null;
    }
}

