/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.eca;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.LocalDispatcher;
import org.ofbiz.core.util.UtilValidate;
import org.w3c.dom.Element;

public class ServiceEcaAction {
    protected String serviceName;
    protected String serviceMode;
    protected boolean resultToContext;
    protected boolean ignoreError;
    protected boolean persist;

    protected ServiceEcaAction() {
    }

    public ServiceEcaAction(Element action) {
        this.serviceName = action.getAttribute("service");
        this.serviceMode = action.getAttribute("mode");
        this.resultToContext = !"false".equals(action.getAttribute("result-to-context"));
        this.ignoreError = !"false".equals(action.getAttribute("ignore-error"));
        this.persist = "true".equals(action.getAttribute("persist"));
    }

    public void runAction(String selfService, DispatchContext dctx, Map context, Map result) throws GenericServiceException {
        if (this.serviceName.equals(selfService)) {
            throw new GenericServiceException("Cannot invoke self on ECA.");
        }
        Map actionContext = dctx.getModelService(this.serviceName).makeValid(context, "IN");
        Map actionResult = null;
        LocalDispatcher dispatcher = dctx.getDispatcher();
        if (this.serviceMode.equals("sync")) {
            actionResult = dispatcher.runSync(this.serviceName, actionContext);
        } else if (this.serviceMode.equals("async")) {
            dispatcher.runAsync(this.serviceName, actionContext, this.persist);
        }
        if (this.resultToContext) {
            context.putAll(dctx.getModelService(selfService).makeValid(actionResult, "IN"));
        }
        if (!this.ignoreError && result != null && "error".equals(actionResult.get("responseMessage"))) {
            result.put("responseMessage", "error");
            String errorMessage = (String)actionResult.get("errorMessage");
            LinkedList<String> errorMessageList = (LinkedList<String>)actionResult.get("errorMessageList");
            Map errorMessageMap = (Map)actionResult.get("errorMessageMap");
            if (UtilValidate.isNotEmpty((String)errorMessage)) {
                if (UtilValidate.isEmpty((String)((String)result.get("errorMessage")))) {
                    result.put("errorMessage", errorMessage);
                } else {
                    if (errorMessageList == null) {
                        errorMessageList = new LinkedList<String>();
                    }
                    errorMessageList.add(0, errorMessage);
                }
            }
            if (errorMessageList != null && errorMessageList.size() > 0) {
                List origErrorMessageList = (List)result.get("errorMessageList");
                if (origErrorMessageList == null) {
                    result.put("errorMessageList", errorMessageList);
                } else {
                    origErrorMessageList.addAll(errorMessageList);
                }
            }
            if (errorMessageMap != null && errorMessageMap.size() > 0) {
                Map origErrorMessageMap = (Map)result.get("errorMessageMap");
                if (origErrorMessageMap == null) {
                    result.put("errorMessageMap", errorMessageMap);
                } else {
                    origErrorMessageMap.putAll(errorMessageMap);
                }
            }
        }
    }
}

