/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelParam;
import org.ofbiz.core.service.ServiceValidationException;
import org.ofbiz.core.service.group.GroupModel;
import org.ofbiz.core.service.group.GroupServiceModel;
import org.ofbiz.core.service.group.ServiceGroupReader;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.ObjectType;
import org.ofbiz.core.util.OrderedSet;

public class ModelService {
    public static final String module = ModelService.class.getName();
    public static final String OUT_PARAM = "OUT";
    public static final String IN_PARAM = "IN";
    public static final String RESPONSE_MESSAGE = "responseMessage";
    public static final String RESPOND_SUCCESS = "success";
    public static final String RESPOND_ERROR = "error";
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String ERROR_MESSAGE_LIST = "errorMessageList";
    public static final String ERROR_MESSAGE_MAP = "errorMessageMap";
    public static final String SUCCESS_MESSAGE = "successMessage";
    public static final String SUCCESS_MESSAGE_LIST = "successMessageList";
    public String name;
    public String description;
    public String engineName;
    public String nameSpace;
    public String location;
    public String invoke;
    public boolean auth;
    public boolean export;
    public boolean validate;
    public boolean useTransaction;
    public boolean requireNewTransaction;
    public Set implServices = new OrderedSet();
    protected Map contextInfo = new HashMap();
    protected List contextParamList = new LinkedList();
    protected boolean inheritedParameters = false;

    public ModelService() {
    }

    public ModelService(ModelService model) {
        this.name = model.name;
        this.description = model.description;
        this.engineName = model.engineName;
        this.nameSpace = model.nameSpace;
        this.location = model.location;
        this.invoke = model.invoke;
        this.auth = model.auth;
        this.export = model.export;
        this.validate = model.validate;
        if (!model.useTransaction) {
            // empty if block
        }
        this.useTransaction = true;
        this.implServices = model.implServices;
        List modelParamList = model.getModelParamList();
        Iterator i = modelParamList.iterator();
        while (i.hasNext()) {
            this.addParam((ModelParam)i.next());
        }
        this.inheritedParameters = model.inheritedParameters();
    }

    public boolean inheritedParameters() {
        return this.inheritedParameters;
    }

    public ModelParam getParam(String name) {
        return (ModelParam)this.contextInfo.get(name);
    }

    public void addParam(ModelParam param) {
        this.contextInfo.put(param.name, param);
        this.contextParamList.add(param);
    }

    public List getAllParamNames() {
        LinkedList<String> nameList = new LinkedList<String>();
        for (ModelParam p : this.contextParamList) {
            nameList.add(p.name);
        }
        return nameList;
    }

    public List getInParamNames() {
        LinkedList<String> nameList = new LinkedList<String>();
        for (ModelParam p : this.contextParamList) {
            if (OUT_PARAM.equals(p.mode)) continue;
            nameList.add(p.name);
        }
        return nameList;
    }

    public void validate(Map test, String mode) throws ServiceValidationException {
        HashMap<String, String> requiredInfo = new HashMap<String, String>();
        HashMap<String, String> optionalInfo = new HashMap<String, String>();
        boolean verboseOn = Debug.verboseOn();
        if (verboseOn) {
            Debug.logVerbose((String)("[ModelService.validate] : Validating context - " + test), (String)module);
        }
        if (mode.equals(OUT_PARAM) && test != null && test.containsKey(RESPONSE_MESSAGE) && test.get(RESPONSE_MESSAGE).equals(RESPOND_ERROR)) {
            if (verboseOn) {
                Debug.logVerbose((String)"[ModelService.validate] : response was an error, not validating.", (String)module);
            }
            return;
        }
        Collection values = this.contextInfo.values();
        for (ModelParam p : values) {
            if (!p.mode.equals("INOUT") && !p.mode.equals(mode)) continue;
            if (!p.optional) {
                requiredInfo.put(p.name, p.type);
                continue;
            }
            optionalInfo.put(p.name, p.type);
        }
        HashMap requiredTest = new HashMap();
        HashMap optionalTest = new HashMap();
        if (test == null) {
            test = new HashMap();
        }
        requiredTest.putAll(test);
        if (requiredTest != null) {
            ArrayList keyList = new ArrayList(requiredTest.keySet());
            for (Object key : keyList) {
                Object value = requiredTest.get(key);
                if (requiredInfo.containsKey(key)) continue;
                requiredTest.remove(key);
                optionalTest.put(key, value);
            }
        }
        if (verboseOn) {
            Debug.logVerbose((String)("[ModelService.validate] : (" + mode + ") Required - " + requiredTest.size() + " / " + requiredInfo.size()), (String)module);
            Debug.logVerbose((String)("[ModelService.validate] : (" + mode + ") Optional - " + optionalTest.size() + " / " + optionalInfo.size()), (String)module);
        }
        try {
            ModelService.validate(requiredInfo, requiredTest, true);
            ModelService.validate(optionalInfo, optionalTest, false);
        }
        catch (ServiceValidationException e) {
            Debug.logError((String)("[ModelService.validate] : (" + mode + ") Required test error: " + e.toString()), (String)module);
            throw e;
        }
    }

    public static void validate(Map info, Map test, boolean reverse) throws ServiceValidationException {
        if (info == null || test == null) {
            throw new ServiceValidationException("Cannot validate NULL maps");
        }
        Set testSet = test.keySet();
        Set keySet = info.keySet();
        if (info.size() == 0 && test.size() == 0) {
            return;
        }
        if (reverse && !testSet.containsAll(keySet)) {
            TreeSet missing = new TreeSet(keySet);
            missing.removeAll(testSet);
            String missingStr = "";
            Iterator iter = missing.iterator();
            while (iter.hasNext()) {
                missingStr = missingStr + (String)iter.next();
                if (!iter.hasNext()) continue;
                missingStr = missingStr + ", ";
            }
            throw new ServiceValidationException("The following required parameters are missing: " + missingStr);
        }
        if (!keySet.containsAll(testSet)) {
            TreeSet extra = new TreeSet(testSet);
            extra.removeAll(keySet);
            String extraStr = "";
            Iterator iter = extra.iterator();
            while (iter.hasNext()) {
                extraStr = extraStr + (String)iter.next();
                if (!iter.hasNext()) continue;
                extraStr = extraStr + ", ";
            }
            throw new ServiceValidationException("Unknown parameters found: " + extraStr);
        }
        for (Object key : testSet) {
            String infoType;
            Object testObject = test.get(key);
            if (ObjectType.instanceOf(testObject, (String)(infoType = (String)info.get(key)), null)) continue;
            String testType = testObject == null ? "null" : testObject.getClass().getName();
            throw new ServiceValidationException("Type check failed for field " + key + "; expected type is " + infoType + "; actual type is: " + testType);
        }
    }

    public List getParameterNames(String mode, boolean optional) {
        ArrayList<String> names = new ArrayList<String>();
        if (!(IN_PARAM.equals(mode) || OUT_PARAM.equals(mode) || "INOUT".equals(mode))) {
            return names;
        }
        if (this.contextInfo.size() == 0) {
            return names;
        }
        for (ModelParam param : this.contextParamList) {
            if (!param.mode.equals("INOUT") && !param.mode.equals(mode) || !optional && (optional || param.optional)) continue;
            names.add(param.name);
        }
        return names;
    }

    public Map makeValid(Map source, String mode) {
        HashMap target = new HashMap();
        if (source == null) {
            return target;
        }
        if (!(IN_PARAM.equals(mode) || OUT_PARAM.equals(mode) || "INOUT".equals(mode))) {
            return target;
        }
        if (this.contextInfo.size() == 0) {
            return target;
        }
        for (ModelParam param : this.contextParamList) {
            String key;
            if (!param.mode.equals("INOUT") && !param.mode.equals(mode) || !source.containsKey(key = param.name)) continue;
            Object value = source.get(key);
            try {
                value = ObjectType.simpleTypeConvert(value, (String)param.type, null, null);
            }
            catch (GeneralException e) {
                Debug.logWarning((String)("[ModelService.makeValid] : Simple type conversion of param " + key + " failed: " + e.toString()), (String)module);
            }
            target.put(key, value);
        }
        return target;
    }

    public List getInParameterSequence(Map source) {
        LinkedList target = new LinkedList();
        if (source == null) {
            return target;
        }
        if (this.contextInfo == null || this.contextInfo.size() == 0) {
            return target;
        }
        for (ModelParam p : this.contextParamList) {
            Object srcObject;
            if (OUT_PARAM.equals(p.mode) || (srcObject = source.get(p.name)) == null) continue;
            target.add(srcObject);
        }
        return target;
    }

    public List getModelParamList() {
        return new LinkedList(this.contextParamList);
    }

    public List getInModelParamList() {
        LinkedList<ModelParam> inList = new LinkedList<ModelParam>();
        for (ModelParam p : this.contextParamList) {
            if (OUT_PARAM.equals(p.mode)) continue;
            inList.add(p);
        }
        return inList;
    }

    public boolean interfaceCheck() {
        return this.engineName.equals("group") || this.implServices.size() > 0;
    }

    public void interfaceUpdate(DispatchContext dctx) throws GenericServiceException {
        if (!this.inheritedParameters) {
            GroupModel group;
            if (this.engineName.equals("group") && this.implServices.size() == 0 && (group = ServiceGroupReader.getGroupModel(this.location)) != null) {
                List groupedServices = group.getServices();
                for (GroupServiceModel sm : groupedServices) {
                    this.implServices.add(sm.getName());
                    Debug.logVerbose((String)("Adding service [" + sm.getName() + "] as interface of: [" + this.name + "]"), (String)module);
                }
            }
            if (this.implServices.size() > 0 && dctx != null) {
                HashMap newInfo = new HashMap();
                LinkedList newParams = new LinkedList();
                for (String serviceName : this.implServices) {
                    ModelService model = dctx.getModelService(serviceName);
                    if (model != null) {
                        Debug.logVerbose((String)("Adding contextInfo from [" + model.name + "] to [" + this.name + "]"), (String)module);
                        newInfo.putAll(model.contextInfo);
                        newParams.addAll(model.contextParamList);
                        continue;
                    }
                    Debug.logWarning((String)("Inherited model [" + serviceName + "] not found for [" + this.name + "]"), (String)module);
                }
                newInfo.putAll(this.contextInfo);
                newParams.addAll(this.contextParamList);
                this.contextInfo = new HashMap(newInfo);
                this.contextParamList = new LinkedList(newParams);
            }
        }
    }
}

