/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import javax.servlet.ServletContext;
import org.ofbiz.core.util.Debug;

public class UtilJ2eeCompat {
    public static final String TOMCAT = "Apache Tomcat";
    public static final String ORION = "Orion";
    public static final String RESIN = "Resin";
    public static final String REX_IP = "TradeCity";
    public static final String OC4J = "Oracle";
    public static final String JRUN = "JRun";
    public static final String JETTY = "Jetty";
    protected static Boolean doFlushOnRenderValue = null;
    protected static Boolean useOutputStreamNotWriterValue = null;
    protected static Boolean useNestedJspException = null;

    public static boolean doFlushOnRender(ServletContext context) {
        UtilJ2eeCompat.initCompatibilityOptions(context);
        return doFlushOnRenderValue;
    }

    public static boolean useOutputStreamNotWriter(ServletContext context) {
        UtilJ2eeCompat.initCompatibilityOptions(context);
        return useOutputStreamNotWriterValue;
    }

    public static boolean useNestedJspException(ServletContext context) {
        UtilJ2eeCompat.initCompatibilityOptions(context);
        return useNestedJspException;
    }

    protected static void initCompatibilityOptions(ServletContext context) {
        if (useOutputStreamNotWriterValue == null || doFlushOnRenderValue == null) {
            boolean doflush = true;
            boolean usestream = true;
            boolean nestjspexception = true;
            String serverInfo = context == null ? "" : context.getServerInfo();
            Debug.logInfo("serverInfo: " + serverInfo);
            if (serverInfo.indexOf(RESIN) >= 0) {
                Debug.logImportant("Resin detected, disabling the flush on the region render from PageContext for better performance");
                doflush = false;
            } else if (serverInfo.indexOf(REX_IP) >= 0) {
                Debug.logImportant("Trade City RexIP detected, using response.getWriter to write text out instead of response.getOutputStream");
                usestream = false;
            } else if (serverInfo.indexOf(TOMCAT) >= 0) {
                Debug.logImportant("Apache Tomcat detected, using response.getWriter to write text out instead of response.getOutputStream");
                usestream = false;
            } else if (serverInfo.indexOf(JRUN) >= 0) {
                Debug.logImportant("JRun detected, using response.getWriter to write text out instead of response.getOutputStream");
                usestream = false;
            } else if (serverInfo.indexOf(JETTY) >= 0) {
                Debug.logImportant("Jetty detected, using response.getWriter to write text out instead of response.getOutputStream");
                usestream = false;
            } else if (serverInfo.indexOf(ORION) >= 0) {
                Debug.logImportant("Orion detected, using non-nested JspException");
                nestjspexception = false;
            }
            doFlushOnRenderValue = new Boolean(doflush);
            useOutputStreamNotWriterValue = new Boolean(usestream);
            useNestedJspException = new Boolean(nestjspexception);
        }
    }
}

