/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps.filter;

import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.DefaultEncryptedCertificate;
import com.atlassian.security.auth.trustedapps.InvalidCertificateException;
import com.atlassian.security.auth.trustedapps.TransportErrorMessage;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.security.auth.trustedapps.UserResolver;
import com.atlassian.security.auth.trustedapps.filter.AuthenticationController;
import com.atlassian.security.auth.trustedapps.filter.Authenticator;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedApplicationFilterAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(TrustedApplicationFilterAuthenticator.class);
    final TrustedApplicationsManager appManager;
    final UserResolver resolver;
    final AuthenticationController authenticationController;

    public TrustedApplicationFilterAuthenticator(TrustedApplicationsManager appManager, UserResolver resolver, AuthenticationController authenticationController) {
        this.appManager = appManager;
        this.resolver = resolver;
        this.authenticationController = authenticationController;
    }

    public Authenticator.Result authenticate(HttpServletRequest request, HttpServletResponse response) {
        ApplicationCertificate certificate;
        Integer protocolVersion;
        String certStr = request.getHeader("X-Seraph-Trusted-App-Cert");
        if (TrustedApplicationFilterAuthenticator.isBlank(certStr)) {
            return new Authenticator.Result.NoAttempt();
        }
        String id = request.getHeader("X-Seraph-Trusted-App-ID");
        if (TrustedApplicationFilterAuthenticator.isBlank(id)) {
            Authenticator.Result.Error result = new Authenticator.Result.Error(new TransportErrorMessage.ApplicationIdNotFoundInRequest());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        String key = request.getHeader("X-Seraph-Trusted-App-Key");
        if (TrustedApplicationFilterAuthenticator.isBlank(key)) {
            Authenticator.Result.Error result = new Authenticator.Result.Error(new TransportErrorMessage.SecretKeyNotFoundInRequest());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        String magicNumber = request.getHeader("X-Seraph-Trusted-App-Magic");
        String version = request.getHeader("X-Seraph-Trusted-App-Version");
        try {
            protocolVersion = !TrustedApplicationFilterAuthenticator.isBlank(version) ? new Integer(version) : null;
        }
        catch (NumberFormatException e) {
            Authenticator.Result.Error result = new Authenticator.Result.Error(new TransportErrorMessage.BadProtocolVersion(version));
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        if (protocolVersion != null && TrustedApplicationFilterAuthenticator.isBlank(magicNumber)) {
            Authenticator.Result.Error result = new Authenticator.Result.Error(new TransportErrorMessage.MagicNumberNotFoundInRequest());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        TrustedApplication app = this.appManager.getTrustedApplication(id);
        if (app == null) {
            Authenticator.Result.Failure result = new Authenticator.Result.Failure(new TransportErrorMessage.ApplicationUnknown(id));
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        try {
            certificate = app.decode(new DefaultEncryptedCertificate(id, key, certStr, protocolVersion, magicNumber), request);
        }
        catch (InvalidCertificateException ex) {
            log.warn("Failed to login trusted application: " + app.getID() + " due to: " + ex);
            log.debug("Failed to login trusted application cause", (Throwable)ex);
            Authenticator.Result.Error result = new Authenticator.Result.Error(ex.getTransportErrorMessage());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        Principal user = this.resolver.resolve(certificate);
        if (user == null) {
            log.warn("User '" + certificate.getUserName() + "' referenced by trusted application: '" + app.getID() + "' is not found.");
            Authenticator.Result.Failure result = new Authenticator.Result.Failure(new TransportErrorMessage.UserUnknown(certificate.getUserName()));
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        if (!this.authenticationController.canLogin(user, request)) {
            log.warn("User '" + certificate.getUserName() + "' referenced by trusted application: '" + app.getID() + "' cannot login.");
            Authenticator.Result.Failure result = new Authenticator.Result.Failure(new TransportErrorMessage.PermissionDenied());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        return new Authenticator.Result.Success(user);
    }

    private static void setFailureHeader(HttpServletResponse response, String message) {
        response.setHeader("X-Seraph-Trusted-App-Status", "ERROR");
        response.addHeader("X-Seraph-Trusted-App-Error", message);
        if (log.isInfoEnabled()) {
            log.info(message, (Throwable)new RuntimeException(message));
        }
    }

    private static boolean isBlank(String input) {
        return input == null || input.trim().length() == 0;
    }
}

