set _PRG_DIR=%~dp0
set JAVA_OPTS=%JAVA_OPTS% -Xms128m -Xmx768m -Datlassian.standalone=JIRA -Dorg.apache.jasper.runtime.BodyContentImpl.LIMIT_BUFFER=true -Dmail.mime.decodeparameters=true 
rem Note: If running JIRA as a Service, settings in this file have no
rem effect. See http://confluence.atlassian.com/display/JIRA/Increasing+JIRA+memory

rem Checks if the JAVA_HOME has a space in it (can cause issues)
SET _marker=%JAVA_HOME: =%
IF NOT "%_marker%" == "%JAVA_HOME%" ECHO JAVA_HOME "%JAVA_HOME%" contains spaces. Please change to a location without spaces if this causes problems.

rem Perm Gen size needs to be increased if encountering OutOfMemoryError: PermGen problems. Specifying PermGen size is not valid on IBM JDKs
set JIRA_MAX_PERM_SIZE=256m
IF EXIST "%_PRG_DIR%\permgen.bat" goto startPermGenCheck
goto skipPermGenCheck
:startPermGenCheck
call "%_PRG_DIR%\permgen.bat"
if ERRORLEVEL 1 goto endPermGenCheck
set JAVA_OPTS=-XX:MaxPermSize=%JIRA_MAX_PERM_SIZE% %JAVA_OPTS%
:endPermGenCheck
set JIRA_MAX_PERM_SIZE=
rem Clear the errorlevel which may have been set by permgen.bat
cmd /c
:skipPermGenCheck

rem use this if you want to import data without notifications
rem set JAVA_OPTS=%JAVA_OPTS% -Datlassian.mail.senddisabled=true -Datlassian.mail.fetchdisabled=true -Datlassian.mail.popdisabled=true

echo If you encounter issues starting up JIRA Standalone Edition, please see the Troubleshooting guide at http://confluence.atlassian.com/display/JIRA/Installation+Troubleshooting+Guide
