<%--
  --  Parameters:
  --   * issue        - an issue object to work on
  --   * tabs         - a collection of field screen tabs
  --   * errortabs    - a collection of tabs with fields that have errors
  --   * selectedtab  - the index of the tab to select starting with 1
  --   * ignorefields - a collection of field ids that should not be shown no matter what
  --   * create       - a boolean value indicating whether issue is being created
  --
  --%>
<%@ taglib uri="webwork" prefix="webwork" %>

<jsp:include page="/includes/js/date_picker.jsp" flush="true" />
<style type="text/css">
<!--
.fieldLabelArea
{
    width: 20% !important;
}

.fieldValueArea
{
    width: 80% !important;
}
-->
</style>
<webwork:if test="parameters['tabs']/size > 1">
    <tr><td width="100%" colspan="2" bgcolor="#ffffff">
        <script language="JavaScript">

            var tabClasses = new Array(<webwork:property value="parameters['tabs']/size" />);
            var j = 0;
            <webwork:iterator value="parameters['tabs']">
                <webwork:if test="parameters['errortabs']/contains(.) == true">tabClasses[j++] = 'errorTabCell';</webwork:if>
                <webwork:else>tabClasses[j++] = 'unselectedTabCell';</webwork:else>
            </webwork:iterator>

            function showTab(tabId)
            {
                for(i = 1; i <= <webwork:property value="parameters['tabs']/size" />; i++)
                {
                    var tableObject = document.getElementById('tab' + i);
                    var tableCellObject = document.getElementById('tabCell' + i);
                    var tabCellTextSelected = document.getElementById('tabCellTextSelected' + i);
                    var tabCellTextNotSelected = document.getElementById('tabCellTextNotSelected' + i);
                    if (i == tabId)
                    {
                        tableObject.className = 'borderedTabBox';
                        tableCellObject.className='selectedTabCell';
                        tabCellTextSelected.style.display ='inline';
                        tabCellTextNotSelected.style.display ='none';
                    }
                    else
                    {
                        tableObject.className = 'borderedTabBoxHidden';
                        tableCellObject.className = tabClasses[i - 1];
                        tabCellTextSelected.style.display ='none';
                        tabCellTextNotSelected.style.display ='inline';
                    }
                }
            }
        </script>

        <%-- Show tab headings --%>
        <table cellpadding=2 cellspacing=0 border=0 width=100% align=center>
            <tr>
            <webwork:iterator value="parameters['tabs']" status="'status'">
                <td id="tabCell<webwork:property value="@status/count" />"
                    <webwork:if test="@status/count == parameters['selectedtab']">class="selectedTabCell"</webwork:if>
                    <webwork:else>
                        <%-- Test if the tab has any errors on it, and if so highlight it --%>
                        <webwork:if test="parameters['errortabs']/contains(.) == true">class="errorTabCell"</webwork:if>
                        <%-- If not simply show normal header --%>
                        <webwork:else>class="unselectedTabCell"</webwork:else>
                    </webwork:else>
                    width=1% nowrap align=center onClick="showTab(<webwork:property value="@status/count"/>);">

			        <webwork:if test="@status/count == parameters['selectedtab']">
                        &nbsp;<span id="tabCellTextSelected<webwork:property value="@status/count" />" class="selectedTabFont" style="display: inline;"><webwork:property value="./name"/></span><span id="tabCellTextNotSelected<webwork:property value="@status/count" />" class="unselectedTabFont" style="display: none;"><a href="javascript:showTab(<webwork:property value="@status/count" />)"><webwork:property value="./name" /></a></span>&nbsp;
			        </webwork:if>
                    <webwork:else>
                        &nbsp;<span id="tabCellTextSelected<webwork:property value="@status/count" />" class="selectedTabFont" style="display: none;"><webwork:property value="./name"/></span><span id="tabCellTextNotSelected<webwork:property value="@status/count" />" class="unselectedTabFont" style="display: inline;"><a href="javascript:showTab(<webwork:property value="@status/count" />)"><webwork:property value="./name" /></a></span>&nbsp;
                    </webwork:else>
                </td>
            </webwork:iterator>
            <td width="100%">&nbsp;</td>
            </tr>
        </table>
        </webwork:if>

        <%-- Show the actual tabs with their fields --%>
        <webwork:iterator value="parameters['tabs']" status="'status'">
        <webwork:if test="parameters['tabs']/size > 1">
        <table id="tab<webwork:property value="@status/count"/>" <webwork:if test="@status/count == parameters['selectedtab']">class="borderedTabBox"</webwork:if><webwork:else>class="borderedTabBoxHidden"</webwork:else> cellpadding="0" cellspacing="0" align="center">
        </webwork:if>

            <%-- Show tab's fields --%>
            <webwork:iterator value="./fieldScreenRenderLayoutItems">
                <%-- Hack to not show issue type as it has been shown on a previous page --%>
                <webwork:if test="parameters['ignorefields'] == null || parameters['ignorefields']/contains(./orderableField/id) == false">
                    <webwork:if test="parameters['create'] == true">
                        <webwork:property value="./createHtml(/, /, parameters['issue'])" escape="'false'" />
                    </webwork:if>
                    <webwork:else>
                        <webwork:property value="./editHtml(/, /, parameters['issue'])" escape="'false'" />
                    </webwork:else>
                </webwork:if>
            </webwork:iterator>
        <webwork:if test="parameters['tabs']/size > 1">
        </table>
        </webwork:if>
        </webwork:iterator>

<webwork:if test="parameters['tabs']/size > 1">
    </td></tr>
</webwork:if>
