<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="webwork" prefix="ui" %>
<%@ taglib uri="jiratags" prefix="jira" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>
<html>
<head>
    <meta content="issuesummary" name="decorator" />
    <title><webwork:text name="'voters.view.title'"/></title>
</head>
<body>
<webwork:if test="/votingEnabled == false">
    <page:applyDecorator name="jirapanel">
        <page:param name="title"><webwork:text name="'voters.view.title'"/></page:param>
        <page:param name="description"><span class="warning"><webwork:text name="'voters.voting.disabled'"/>.</span></page:param>
        <page:param name="width">100%</page:param>
    </page:applyDecorator>
</webwork:if>
<%--We know when this is false the Issue doesn't exist and has no voters.
All exception handling and error rendering is done by the issuesummary decorator.--%>
<webwork:elseIf test="/issueValid == true">
    <page:applyDecorator name="jirapanel">
        <page:param name="title"><webwork:text name="'voters.view.title'"/></page:param>
        <page:param name="width">100%</page:param>
        <page:param name="description">
            <webwork:text name="'voters.vote.description'">
                <webwork:param name="'value0'"><b><a href="<%= request.getContextPath() %>/browse/<webwork:property value="/issue/string('key')" />"><webwork:property value="/issue/string('key')" /></a></b></webwork:param>
            </webwork:text>.
        </page:param>

        <webwork:if test="/issue/string('resolution') == null">
            <webwork:if test="issueReportedByMe == false">
                <webwork:if test="votedAlready == true">
                    <img src="<%= request.getContextPath() %>/images/icons/bullet_creme.gif" height="8" width="8" border="0" align="absmiddle" alt="" />
                    <webwork:text name="'voters.vote.remove'">
                        <webwork:param name="'value0'"><b><a href="ViewVoters!removeVote.jspa?key=<webwork:property value="/issue/string('key')"/>"></webwork:param>
                        <webwork:param name="'value1'"></a></b></webwork:param>
                    </webwork:text>
                </webwork:if>
                <webwork:else>
                    <img src="<%= request.getContextPath() %>/images/icons/bullet_creme.gif" height="8" width="8" border="0" align="absmiddle" alt="" />
                    <webwork:text name="'voters.vote.add'">
                        <webwork:param name="'value0'"><b><a href="ViewVoters!addVote.jspa?key=<webwork:property value="/issue/string('key')"/>"></webwork:param>
                        <webwork:param name="'value1'"></a></b></webwork:param>
                    </webwork:text>
                </webwork:else>
            </webwork:if>
            <webwork:else>
                <span class="warning"><webwork:text name="'common.words.note'"/></span>:&nbsp;<webwork:text name="'issue.operations.novote'"/>
            </webwork:else>
        </webwork:if>
        <webwork:else>
            <span class="warning"><webwork:text name="'common.words.note'"/></span>:&nbsp;<webwork:text name="'issue.operations.voting.resolved'"/>
        </webwork:else>

    </page:applyDecorator>

    <p>

<%-- large outside table --%>
    <table cellpadding="2" cellspacing="0" border="0" width="50%" align="left">

    <tr>
        <td width="50%" valign="top">
<%-- Voters 'header' table --%>
            <table cellpadding="2" cellspacing="0" border="0" width="100%" align="center">
                <tr>
                    <td style="background-color: #bbb; color: #fff; font-weight: bold; width: 1%; white-space: nowrap; text-align: center;">
                        &nbsp;<webwork:text name="'voters.list'"/>&nbsp;
                    </td>
                    <td width="100%">
                        &nbsp;
                    </td>
                </tr>
            </table>
<%-- Voters list --%>
            <div class="borderedBox">
<%-- only show voters table if they exist --%>
                <webwork:property value="voters">
                    <webwork:if test=". != null && ./empty == false">
                        <table cellpadding="3" cellspacing="0" border="0" width="100%">
                            <tr bgcolor="#f0f0f0" width="100%">
                                <th class="colHeaderLink">
                                    <font size="2"><b><webwork:text name="'common.words.fullname'"/></b></font>
                                    <span class="smallgrey">(<webwork:text name="'common.words.username'"/>)</span>
                                </th>
                            </tr>
                            <webwork:iterator status="'status'">
                            <tr class="<webwork:if test="@status/odd == true">rowNormal</webwork:if><webwork:else>rowAlternate</webwork:else>">
                                <td valign="top">
                                    <jira:formatuser user="./name" type="'profileLink'" id="'voter_link'"/>
                                    <span class="smallgrey"> (<webwork:property value="./name" />)</span>
                                </td>
                            </tr>
                            </webwork:iterator>
                        </table>
                    </webwork:if>
                    <webwork:else>
                        <table cellpadding="2" cellspacing="0" border="0" width="80%" align="center">
                            <tr><td nowrap><webwork:text name="'voters.novoters'"/>.</td></tr>
                        </table>
                    </webwork:else>
                </webwork:property>
            </div>
        </td>
    </tr>
    </table>
</webwork:elseIf>
</body>
</html>
