<%@ page import="com.atlassian.jira.ComponentManager"%>
<%@ page import="com.atlassian.jira.util.BrowserUtils" %>
<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="webwork" prefix="ui" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>
<%@ taglib uri="jiratags" prefix="jira" %>
<webwork:bean id="fieldVisibility" name="'com.atlassian.jira.web.bean.FieldVisibilityBean'" />
<html>
<head>
    <meta content="issuesummary" name="decorator" />
    <title>[#<webwork:property value="/issueObject/key" />] <webwork:property value="/issueObject/summary" /></title>
    <content tag="section">find_link</content>
</head>
<body>
<style type="text/css">
<!--
.fieldArea .fieldLabelArea { width: 10%; }
.fieldArea .fieldValueArea { width: 90%; }
#pinCommentContainer { float: right; font-size: 10px; }
#pinCommentContainer a { margin: 0 0.2em; }
-->
</style>
<%@ include file="/includes/errormessages.jsp" %>

<%-- Make the Issue object referenceable via '@issue' (eg. from issue_descriptiontable.jsp) --%>
<webwork:property value="/issueObject" id="issue" />
<%-- Put the issue GV on the stack --%>
<webwork:property value="issue">

<jsp:include page="/includes/panels/issue_headertable.jsp" />

<webwork:property value="./long('project')">

    <webwork:if test="@fieldVisibility/fieldHidden(., 'timetracking', ../string('type')) == false">
        <jsp:include page="/includes/panels/issue/view_timetracking.jsp" />
    </webwork:if>
    <webwork:if test="showIssueDetails(., ..) == true">
        <br>
        <table cellpadding="0" cellspacing="0" border="0" bgcolor="#bbbbbb" WIDTH="100%" align="center"><tr><td>
        <table cellpadding="4" cellspacing="1" border="0" width="100%" bgcolor="#bbbbbb" id="issueDetailsTable">

        <jsp:include page="/includes/panels/issue/view_attachments.jsp" />

        <webwork:if test="@fieldVisibility/fieldHidden(., 'environment', ../string('type')) == false && ../string('environment') != null && ../string('environment')/length > 0">
            <tr>

                <td bgcolor="#f0f0f0" width="20%" valign="top">
                    <b><webwork:text name="'issue.field.environment'" />:</b>
                </td>
                <td id="environment_field" bgcolor="#ffffff" valign="top">
                    <webwork:property value="/renderedEnvironmentFieldValue" escape="'false'" />
                </td>
            </tr>
        </webwork:if>

        <jsp:include page="/includes/panels/issue/view_linking.jsp" />
        <jsp:include page="/includes/panels/issue/view_trackbacks.jsp" />

        </table>
        </td></tr></table>
    </webwork:if>
</webwork:property>
<webwork:if test="/fieldScreenRenderTabs/empty == false">
<br>
<jsp:include page="/includes/panels/issue/view_customfields.jsp" />
</webwork:if>
<br>
<jsp:include page="/includes/panels/issue/view_subtaskissues.jsp" />
<%@ include file="/includes/panels/issue_descriptiontable.jsp" %>
<%@ include file="/includes/trackback_rdf.jsp"%>
</webwork:property>
<br>
<jsp:include page="/includes/panels/issue/actions.jsp" />

<webwork:if test="hasIssuePermission('comment', issue) == true">
<script language="JavaScript" type="text/javascript" src="<%= ComponentManager.getInstance().getWebResourceManager().getStaticResourcePrefix() %>/includes/js/pincomment.js"></script>

<%-- Added this so that the cancel button can display the tooltip JRA-10552--%>
<%request.setAttribute("cancelModifierKey", BrowserUtils.getModifierKey());%>

<div id="commentDiv" style="display:none;">
    <page:applyDecorator name="jiraform">
        <page:param name="action"><webwork:url value="'/secure/AddComment.jspa'" /></page:param>
        <page:param name="submitName"><webwork:property value="text('common.forms.add')"/> </page:param>
        <page:param name="buttons">
<%--            <input class="spaced" type="reset" value="<webwork:property value="text('common.forms.clear')"/>" />--%>
            <input type="button" class="spaced" onclick="return hideComment();" value="<webwork:property value="text('common.forms.cancel')"/>"
                   accesskey="<webwork:text name="'common.forms.cancel.accesskey'" />"
                   title="<webwork:property value="text('common.forms.cancel')"/> (<webwork:property value="@cancelModifierKey"/> + <webwork:text name="'common.forms.cancel.accesskey'" />)" />
        </page:param>
        <page:param name="title"><span id="pinCommentContainer">[<a id="pinComment" href="#" onclick="toggleMenu('commentDiv', this);return false;"></a>]</span><webwork:text name="'comment.add.title'"/></page:param>
        <page:param name="width">100%</page:param>

        <webwork:property value="/fieldScreenRendererLayoutItemForField(/field('comment'))/fieldLayoutItem/orderableField/createHtml(/fieldScreenRendererLayoutItemForField(/field('comment'))/fieldLayoutItem, /, /, issueObject, null)" escape="'false'" />

        <ui:component name="'id'" template="hidden.jsp" theme="'single'"  />
    </page:applyDecorator>

<script language="JavaScript" type="text/javascript">
<!--
    <webwork:bean name="'org.apache.commons.lang.StringEscapeUtils'" id="escapeUtils" />

    initPinComments('<webwork:property value="@escapeUtils/escapeJavaScript(text('comment.pin.showText'))" />',
                    '<webwork:property value="@escapeUtils/escapeJavaScript(text('comment.pin.showTitle'))" />',
                    '<webwork:property value="@escapeUtils/escapeJavaScript(text('comment.pin.hideText'))" />',
                    '<webwork:property value="@escapeUtils/escapeJavaScript(text('comment.pin.hideTitle'))" />');

    restoreMenu('commentDiv','pinComment');

    function showComment()
    {
        try
        {
            var commentDiv = document.getElementById("commentDiv");
            commentDiv.style.display = 'block';
            restoreMenu('commentDiv','pinComment')
            var commentElem = document.getElementById("comment");
            if(commentElem)
            {
                setTimeout('document.getElementById("comment").focus();', 20);
            }
            else
            {
                //if we're currently previewing, then there wont be a form element to focus on.  So lets
                //just scroll to the div.
                window.scroll(0, commentDiv.offsetTop);
            }
            return false;
        } catch (e) { return true; }
    }

    function hideComment()
    {
        try
        {
            var commentDiv = document.getElementById("commentDiv");
            commentDiv.style.display = 'none';
            document.getElementById("comment").value = "";
            // Put try/catch around the statement such that it does not break on IE. IE does not like
            // setting focus on hidden elements. We need to set focus as JRA-8284 happens on Firefox otherwise.
            setTimeout('try { document.getElementById("comment").focus(); } catch (e) {}', 20);
            return true;
        } catch (e) { return false; }
    }

//-->
</script>

</div>
</webwork:if>
</body>
</html>
