<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="webwork" prefix="ui" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>
<%@ include file="/includes/js/multipickerutils.jsp" %>

<html>
<head>
    <meta content="issuesummary" name="decorator" />
	<title><webwork:text name="'watcher.manage.title'"/></title>
</head>

<body>
<webwork:if test="/watchingEnabled == false">
    <page:applyDecorator name="jirapanel">
        <page:param name="title"><webwork:text name="'watcher.manage.title'"/></page:param>
        <page:param name="description"><span class="warning"><webwork:text name="'watcher.disabled'"/>.</span></page:param>
        <page:param name="submitName"> <webwork:property value="text('watcher.manage.add')"/> </page:param>
        <page:param name="width">100%</page:param>
        <img src="<%= request.getContextPath() %>/images/icons/bullet_creme.gif" height=8 width=8 border=0 align=absmiddle>
            <webwork:text name="'watcher.browse.projects'">
                <webwork:param name="'value0'"><b><a href="<%= request.getContextPath() %>/secure/BrowseProjects.jspa"></webwork:param>
                <webwork:param name="'value1'"></a></b></webwork:param>
            </webwork:text>
    </page:applyDecorator>
</webwork:if>
<%--We know when this is false the Issue doesn't exist and has no watchers.
All exception handling and error rendering is done by the issuesummary decorator.--%>
<webwork:elseIf test="/issueValid == true">

    <page:applyDecorator name="jirapanel">
        <page:param name="action">ManageWatchers.jspa</page:param>
        <page:param name="cancelURI"><webwork:property value="issuePath" /></page:param>
        <page:param name="submitName"> <webwork:property value="text('watcher.manage.add')"/> </page:param>
        <page:param name="title"><webwork:text name="'watcher.manage.title'"/></page:param>
        <page:param name="width">100%</page:param>
        <page:param name="description">
            <webwork:text name="'watcher.manage.desc'">
                <webwork:param name="'value0'"><b><a href="<%= request.getContextPath() %>/browse/<webwork:property value="/issue/string('key')" />"><webwork:property value="/issue/string('key')" /></a></b></webwork:param>
            </webwork:text>
        </page:param>

        <webwork:if test="watching == true">
            <img src="<%= request.getContextPath() %>/images/icons/bullet_creme.gif" height=8 width=8 border=0 align=absmiddle>
            <webwork:text name="'watcher.manage.stop.watch'">
                <webwork:param name="'value0'"><b><a href="ManageWatchers!stopWatching.jspa?key=<webwork:property value="/issue/string('key')"/>"></webwork:param>
                <webwork:param name="'value1'"></a></b></webwork:param>
            </webwork:text>
            - <webwork:text name="'watcher.manage.start.desc'"/>.
        </webwork:if>
        <webwork:else>
            <img src="<%= request.getContextPath() %>/images/icons/bullet_creme.gif" height=8 width=8 border=0 align=absmiddle>
            <webwork:text name="'watcher.manage.start.watch'">
                <webwork:param name="'value0'"><b><a href="ManageWatchers!startWatching.jspa?key=<webwork:property value="/issue/string('key')"/>"></webwork:param>
                <webwork:param name="'value1'"></a></b></webwork:param>
            </webwork:text>
            - <webwork:text name="'watcher.manage.stop.desc'"/>.
        </webwork:else>

    </page:applyDecorator>

    <p>
    <webwork:property value="/userPickerHtml" escape="false"/>
</webwork:elseIf>
</body>
</html>
