<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="webwork" prefix="ui" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>
<html>
<head>
    <meta content="issuesummary" name="decorator" />
    <title><webwork:text name="'editissue.title'"/>: <webwork:property value="summary" />
        <webwork:if test="/issueValid == 'true'">
          [<webwork:property value="issue/string('key')" />]
        </webwork:if>
    </title>
</head>
<body>
<webwork:if test="/issueValid == 'true' && editable == 'true'">
    <page:applyDecorator name="jiraform">
        <page:param name="action">EditIssue.jspa</page:param>
        <page:param name="cancelURI"><webwork:property value="issuePath" /></page:param>
        <page:param name="submitName"><webwork:text name="'common.forms.update'" /></page:param>
        <page:param name="autoSelectFirst">false</page:param>
        <page:param name="title"><webwork:text name="'editissue.title'"/></page:param>
        <page:param name="width">100%</page:param>
        <page:param name="multipart">true</page:param>
        <page:param name="description"><webwork:text name="'editissue.desc'"/></page:param>

        <webwork:if test="/issueExists == true">

            <webwork:component template="issuefields.jsp" name="'createissue'">
                <webwork:param name="'issue'" value="/issueObject"/>
                <webwork:param name="'tabs'" value="/fieldScreenRenderTabs"/>
                <webwork:param name="'errortabs'" value="/tabsWithErrors"/>
                <webwork:param name="'selectedtab'" value="/selectedTab"/>
                <webwork:param name="'ignorefields'" value="/ignoreFieldIds"/>
                <webwork:param name="'create'" value="'false'"/>
            </webwork:component>

            <jsp:include page="/includes/panels/updateissue_comment.jsp" />

            <ui:component name="'id'" template="hidden.jsp"  theme="'single'" />

        </webwork:if>
    </page:applyDecorator>
</webwork:if>
<webwork:elseIf test="/issueValid == 'true'">
    <page:applyDecorator name="jiraform">
        <webwork:include page="/includes/editissue-notloggedin.jsp">
            <webwork:if test="hasEditIssuePermission(/issueObject) == 'true'">
                <webwork:param name="'errormessage'" value="'editissue.error.no.edit.workflow'" />
            </webwork:if>
            <webwork:else>
                <webwork:param name="'errormessage'" value="'editissue.error.no.edit.permission'" />
            </webwork:else>
        </webwork:include>
	</page:applyDecorator>
</webwork:elseIf>
</body>
</html>
