<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="webwork" prefix="ui" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>
<html>
<head>
    <webwork:if test="canDelete == true">
        <title><webwork:text name="'deletefilter.title'"><webwork:param name="'value0'"><webwork:property value="filterName" /></webwork:param></webwork:text></title>
    </webwork:if>
    <webwork:else>
        <title><webwork:text name="'deletefilter.title.no.filter'"/></title>
    </webwork:else>
    <content tag="section">find_link</content>
</head>
<body>
    <table cellpadding="0" cellspacing="0" border="0" width="100%">
    <tr>
    <td class="filterSummaryCell">
        <jsp:include page="/includes/navigator/summary-pane.jsp" />
    </td>
    <td bgcolor="#ffffff" valign="top">
        <table width="100%" cellpadding="10" cellspacing="0" border="0">
            <tr>
            <td>
                <webwork:if test="canDelete == true">
                    <page:applyDecorator name="jiraform">
                        <page:param name="title"><webwork:text name="'deletefilter.title'"><webwork:param name="'value0'"><webwork:property value="filterName" /></webwork:param></webwork:text></page:param>
                        <page:param name="description"><p><webwork:text name="'deletefilter.confirm'"/></p></page:param>
                        <page:param name="width">100%</page:param>
                        <page:param name="action">DeleteFilter!delete.jspa</page:param>
                        <page:param name="submitName"><webwork:text name="'common.words.delete'"/></page:param>
                        <page:param name="cancelURI">ManageFilters.jspa</page:param>

                        <webwork:if test="otherFavouriteCount > 0">
                            <ui:component label="text('deletefilter.other.favourite.filter')" name="'otherFavouriteCount'" template="textlabel.jsp" >
                                <ui:param name="'description'">
                                    <webwork:text name="'deletefilter.other.favourite.filter.desc'"/>
                                </ui:param>
                            </ui:component>
                        </webwork:if>
                        <webwork:if test="subscriptionCount > 0">
                            <ui:component label="text('deletefilter.subscriptions.attached.to.this.filter')" name="'subscriptionCount'" template="textlabel.jsp" >
                                <ui:param name="'description'">
                                    (<webwork:text name="'deletefilter.view.subscriptions'">
                                        <webwork:param name="'value0'"><a href="<%= request.getContextPath() %>/secure/ViewSubscriptions.jspa?filterId=<webwork:property value="filterId" />"></webwork:param>
                                        <webwork:param name="'value0'"></a></webwork:param>
                                    </webwork:text>)
                                </ui:param>
                            </ui:component>
                            <tr>
                                <td bgcolor=#ffffff>&nbsp;</td>
                                <td bgcolor=#ffffff width="70%">
                                    <webwork:text name="'deletefilter.deleteSubs'"/>
                                </td>
                            </tr>
                        </webwork:if>
                        <webwork:else>
                            <tr>
                                <td bgcolor=#ffffff>&nbsp;</td>
                                <td bgcolor=#ffffff>
                                    <webwork:text name="'deletefilter.noSubs'"/>
                                </td>
                            </tr>
                        </webwork:else>
                        <ui:component name="'filterId'" template="hidden.jsp" />
                    </page:applyDecorator>
                </webwork:if>
                <webwork:else>
                    <page:applyDecorator name="jiraform">
                        <page:param name="title"><webwork:text name="'deletefilter.title.no.filter'"/></page:param>
                        <page:param name="width">100%</page:param>
                        <page:param name="cancelURI">ManageFilters.jspa</page:param>
                        <page:param name="description">
                            <span class="warning">
                                <webwork:text name="'deletefilter.can.not.delete'"/>
                            </span>

                        </page:param>
                    </page:applyDecorator>
                </webwork:else>

            </td>
            </tr>
        </table>
    </td>
    </tr>
    </table>
</body>
</html>

