<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>
<html>
<head>
    <title><webwork:text name="'browseprojects.title'" /></title>
    <meta name="decorator" content="general" />
    <content tag="section">browse_link</content>
</head>
<body>
<script type="text/javascript">window.dhtmlHistory.create();</script>
<div id="content">
    <webwork:if test="/categories/size > 0">
        <div id="content-top">
            <h2 class="browse-projects"><webwork:text name="'browseprojects.title'"/></h2>
        </div>
        <div id="main-content" class="browse-projects">
            <webwork:if test="/showTabs() == true">
                <ul class="vertical tabs">
                    <webwork:iterator value="tabs" status="'status'">
                        <li id="<webwork:property value="./id" />-panel-tab" class="<webwork:if test="@status/first == true">first </webwork:if><webwork:if test="/selectedCategory == ./id">active</webwork:if>">
                           <a id="<webwork:property value="./id" />-panel-tab-lnk" rel="<webwork:property value="./id" />" title="<webwork:property value="./description" />" href="<%= request.getContextPath() %>/secure/BrowseProjects.jspa?selectedCategory=<webwork:property value="./id" />"><strong><webwork:property value="./name" /></strong></a>
                        </li>
                    </webwork:iterator>
                    <li id="all-panel-tab" class="<webwork:if test="/selectedCategory == 'all'">active</webwork:if>">
                       <a id="all-panel-tab-lnk" rel="all" title="<webwork:text name="'browse.projects.all.desc'"/>" href="<%= request.getContextPath() %>/secure/BrowseProjects.jspa?selectedCategory=all"><strong><webwork:text name="'browse.projects.all'"/></strong></a>
                    </li>
                </ul>
            </webwork:if>
            <div id="project-tab" class="category-list">
                <div id="primary" class="column full">
                    <webwork:iterator value="categories" status="'status'">
                        <div class="module<webwork:if test="./all == true"> inall</webwork:if> <webwork:if test="/selectedCategory == ./id || (/selectedCategory == 'all' && ./all == true)">active</webwork:if><webwork:else>hidden</webwork:else>" id="<webwork:property value="./id" />-panel">
                            <h3><webwork:property value="./name" /></h3>
                            <webwork:property value="./projects">
                                <%@ include file="/includes/project/projectstable.jsp" %>
                            </webwork:property>
                        </div>
                    </webwork:iterator>
                </div>
            </div>
        </div>
    </webwork:if>
    <webwork:else>
        <div id="main-content" class="browse-projects">
            <div id="primary" class="column full">
                <table  border="0" cellpadding="3" cellspacing="1" width="100%">
                    <%@ include file="/includes/noprojects.jsp" %>
                </table>
            </div>
        </div>
    </webwork:else>
</div>
</body>
</html>
