<%@ page import="com.atlassian.jira.ManagerFactory,
                 com.opensymphony.workflow.spi.WorkflowStore,                 
                 com.opensymphony.workflow.FactoryException,
                 com.opensymphony.workflow.basic.BasicWorkflow,
                 java.util.List,
                 java.util.Iterator,
                 java.io.PrintWriter,
                 java.io.IOException,
                 java.util.Map,
                 java.util.Collection,
                 com.opensymphony.workflow.Condition,
                 com.opensymphony.util.TextUtils,
                 com.opensymphony.workflow.loader.*"%>

<style>
.step {
    padding: 4px;
}
.action {
    background: #fffffc;
    border: 1px solid #bbb;
    padding: 4px;
}

.restrictor {
    margin: 0px 0px 1px 8px;
}

.condition {
    border: 1px dashed #bbb;
    margin: 1px 1px 4px 8px;
    padding: 4px;
}
.grid {
    margin: 2px 0px 5px 0px;
    border-collapse: collapse;
}
.grid th  {
    border: 1px solid #ccc;
    padding: 2px 4px 2px 4px;
    background: #f0f0f0;
    text-align: center;
}
.grid td  {
    border: 1px solid #ccc;
    padding: 3px 4px 3px 4px;
}
.gridHover {
	background-color: #f9f9f9;
}
.smalltext {
    color: #666666;
    font-size: 10px;
}
</style>
<%
    // WorkflowStore store = ManagerFactory.getWorkflowManager().getStore();

    try
    {
        BasicWorkflow workflow = new BasicWorkflow("mike@atlassian.com");
        String[] workflowNames = workflow.getWorkflowNames();

        for (int i = 0; i < workflowNames.length; i++)
        {
            String workflowName = workflowNames[i];
            %>
            <h1>Workflow: <%= workflowName %></h1>

<%!
            static WorkflowDescriptor descriptor = null;
%>

<%
            descriptor = workflow.getWorkflowDescriptor(workflowName);
%>

            <h2>Initial Actions</h2>
<%
            printActions(out, descriptor.getInitialActions());
%>

            <h2>Global Actions</h2>
<%
            printActions(out, descriptor.getGlobalActions());
%>
            <h2>Steps</h2>
<%
            printSteps(out, descriptor.getSteps());
%>

            <%
        }
    }
    catch (Exception e)
    {
        out.println(e.toString());
    }
%>

<%!
    public void printSteps(JspWriter out, Collection steps) throws IOException
    {
        for (Iterator iterator = steps.iterator(); iterator.hasNext();)
        {
            StepDescriptor step = (StepDescriptor) iterator.next();
            out.println("<div class=step>");
            out.println("<h3>" + step.getName() + " &nbsp;<span class=smalltext>(<b>id</b>: " + step.getId() + ")</span></h3>");

            printActions(out, step.getActions());
            out.println("</div>");
        }
    }

    public void printActions(JspWriter out, Collection actions) throws IOException
    {
        for (Iterator iterator = actions.iterator(); iterator.hasNext();)
        {
            ActionDescriptor actionDescriptor = (ActionDescriptor) iterator.next();
            printAction(out, actionDescriptor);
        }
    }

    public void printAction(JspWriter out, ActionDescriptor action) throws IOException
    {
        out.println("<div class=action>");
        out.println("<h3>" + action.getName() + " &nbsp;<span class=smalltext>(<b>id</b>: " + action.getId() + ")</span></h3>");
        out.println("<b>View</b>: " + TextUtils.noNull(action.getView(), "none set") + "<br>");

        // out.println("<b>Auto execute?</b> " + (action.getAutoExecute() ? "<font color=#darkgreen>TRUE" : "<font color=#darkred>FALSE") + "</font><br>");

        RestrictionDescriptor restriction = action.getRestriction();

        if (restriction == null)
        {
            out.println("<b>Restrictor:</b><br>");
            out.println("<div class=restrictor>");
            out.println("None<br>");
        }
        else
        {
            ConditionsDescriptor conditionsDescriptor = restriction.getConditionsDescriptor();
            out.println("<b>Restrictor</b> &nbsp; <span class=smalltext>(type: " + conditionsDescriptor.getType() + ")</span><br>");
            out.println("<div class=restrictor>");
            List conditions = conditionsDescriptor.getConditions();
            for (Iterator iterator = conditions.iterator(); iterator.hasNext();)
            {
                ConditionDescriptor condition = (ConditionDescriptor) iterator.next();
                printCondition(out, condition);
            }
        }
        out.println("</div>");

        ResultDescriptor unconditionalResult = action.getUnconditionalResult();
        printResult(out, unconditionalResult);

        out.println("</div>");
    }

    public void printCondition(JspWriter out, ConditionDescriptor condition) throws IOException
    {
        out.println("<div class=condition>");
        out.println("<div class=conditionheader><b>Name</b>: " + TextUtils.noNull(condition.getName(), "none set"));
        out.println("&nbsp; <span class=smalltext>(type: " + condition.getType() + ")</span></div>");
        printArgs(out, condition.getArgs());
        out.println("</div>");
    }

    public void printResult(JspWriter out, ResultDescriptor result) throws IOException
    {
        out.println("<div class=condition>");

        StepDescriptor targetStep = descriptor.getStep(result.getStep());
        out.println("<div class=conditionheader><b>RESULT</b>: " + TextUtils.noNull(targetStep.getName(), "none set"));
        out.println("&nbsp; <span class=smalltext>(id: " + result.getStep() + ")</span></div>");


        if (result.getPreFunctions().size() > 0)
        {
            out.println("<h4>Pre Functions</h4>");
            printFunctions(out, result.getPreFunctions());
        }

        if (result.getPostFunctions().size() > 0)
        {
            out.println("<h4>Post Functions</h4>");
            printFunctions(out, result.getPostFunctions());
        }

        out.println("</div>");
    }


    public void printFunctions(JspWriter out, List functions) throws IOException
    {
        for (Iterator iterator = functions.iterator(); iterator.hasNext();)
        {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor) iterator.next();
            printFunction(out, functionDescriptor);
        }
    }

    public void printFunction(JspWriter out, FunctionDescriptor function) throws IOException
    {
        out.println("<div class=condition>");
        out.println("<div class=conditionheader><b>Name</b>: " + TextUtils.noNull(function.getName(), "none set"));
        out.println("&nbsp; <span class=smalltext>(type: " + function.getType() + ")</span></div>");
        printArgs(out, function.getArgs());
        out.println("</div>");
    }

    public void printArgs(JspWriter out, Map arguments) throws IOException
    {
        out.println("<table class=grid><tr><th>Name</th><th>Value</th></tr>");

        for (Iterator iterator = arguments.entrySet().iterator(); iterator.hasNext();)
        {
            Map.Entry entry = (Map.Entry) iterator.next();
            out.println("<tr><td>" + entry.getKey() + "</td><td>" + entry.getValue() + "</td></tr>");
        }

        out.println("</table>");
    }

%>
