<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>

<%@ page import="com.yourkit.api.Controller" %>
<%@ page import="com.yourkit.api.ProfilingModes" %>
<%!
    private String stopMemoryRecording(Controller controller)
    {
        try
        {
            controller.stopAllocationRecording();
            return "Successfully stoped allocation recording";
        }
        catch (Exception e)
        {
            // Show error to the screen
            e.printStackTrace();
            throw new RuntimeException("Unable to stop allocation recording, cause: " + e.getMessage());
        }
    }

    private String stopCPURecording(Controller controller)
    {
        try
        {
            controller.stopCPUProfiling();
            return "Successfully stoped CPU times measuring";
        }
        catch (Exception e)
        {
            // Show error to the screen
            e.printStackTrace();
            throw new RuntimeException("Unable to stop CPU times measuring, cause: " + e.getMessage());
        }
    }

    private String dumpMemoryInfo(Controller controller)
    {
        try
        {
            String filePath = controller.captureMemorySnapshot();
            return "Successfully generated a memory snapshot to: " + filePath + " please attach this file to a support request.";
        }
        catch (Exception e)
        {
            // Show error to the screen
            e.printStackTrace();
            throw new RuntimeException("Unable to create a yourkit memory snapshot, cause: " + e.getMessage());
        }
    }

    private String dumpCPUInfo(Controller controller)
    {
        try
        {
            String filePath = controller.captureCPUSnapshot(false);
            return "Successfully generated a cpu snapshot to: " + filePath + " please attach this file to a support request.";
        }
        catch (Exception e)
        {
            // Show error to the screen
            e.printStackTrace();
            throw new RuntimeException("Unable to create a yourkit cpu snapshot, cause: " + e.getMessage());
        }
    }

    private String startCPURecording(Controller controller)
    {
        try
        {
            controller.startCPUProfiling(ProfilingModes.CPU_SAMPLING | ProfilingModes.CPU_J2EE, null);
            return "Successfully started CPU times measuring";
        }
        catch (Exception e)
        {
            // Show error to the screen
            e.printStackTrace();
            throw new RuntimeException("Unable to start yourkit cpu recording, cause: " + e.getMessage());
        }
    }

    private String startMemoryRecording(Controller controller)
    {
        try
        {
            controller.startAllocationRecording(ProfilingModes.ALLOCATION_RECORDING_ADAPTIVE);
            return "Successfully started allocation recording";
        }
        catch (Exception e)
        {
            // Show an error on the screen
            e.printStackTrace();
            return "Unable to start yourkit memory recording, cause: " + e.getMessage();
        }
    }

%>
<html>
<body>
<!--<h2>Manage YourKit CPU/Memory Profiling</h2>-->

<!--<p>This page lets you start YourKit CPU/Memory profiling recordings and allows you to generate CPU/Memory snapshots.-->
<!--Need to have enabled YourKit as specified in the instructions <a href="http://confluence.atlassian.com/display/JIRA/Profiling+Memory+and+CPU+usage+with+YourKit">here</a> The snapshots-->
<!--will be saved to the directory you specified via the 'dir' property provided to the -Xrunyjpagent JVM argument.</p>-->
<%
    String error = null;
    String message = null;
    try
    { %>
<%
        String action = request.getParameter("action");
        Controller controller = new Controller();
        if ("StartCPURecording".equals(action))
        {
            message = startCPURecording(controller);
        }
        else if ("StartMemoryRecording".equals(action))
        {
            message = startMemoryRecording(controller);
        }
        else if ("DumpCPUInfo".equals(action))
        {
            message = dumpCPUInfo(controller);
        }
        else if ("DumpMemoryInfo".equals(action))
        {
            message = dumpMemoryInfo(controller);
        }
        else if ("StopCPURecording".equals(action))
        {
            message = stopCPURecording(controller);
        }
        else if ("StopMemoryRecording".equals(action))
        {
            message = stopMemoryRecording(controller);
        }
    }
    catch (RuntimeException re)
    {
        re.printStackTrace();
        error = re.getMessage();
    }
    catch (Throwable t)
    {
        t.printStackTrace();
        error = "An unknown error occurred, caused by: " + t.getMessage();
    }
%>

<page:applyDecorator name="jirapanel">
    <page:param name="title">Manage YourKit CPU/Memory Profiling</page:param>
    <page:param name="width">100%</page:param>
    <page:param name="description">
        This page lets you generate <a href="http://www.yourkit.com/">YourKit</a> CPU/Memory snapshots.
        You need to have enabled YourKit as specified in the instructions <a href="<webwork:component name="'external.link.jira.confluence.doc.yourkit.profile'" template="externallink.jsp" />">here</a>. The snapshots
        will be saved to the directory you specified via the 'dir' property provided to the YourKit agent JVM argument.
    </page:param>
</page:applyDecorator>

<table class="grid defaultWidth centered">
    <tr>
        <th width="50%">
            Memory Profiling
        </th>
        <th>
            CPU Profiling
        </th>
    </tr>
    <tr>
        <td valign="top">
            You may want to run the YourKit Memory profiler if your application is getting out of memory errors.

            <p/>
            <!-- NOTE: Comment this in if you would like to be able to take a snapshot of memory allocations -->
            <%--<a href="<%=request.getContextPath()%>/secure/admin/manageyourkitprofiling.jsp?action=StartMemoryRecording">Start--%>
            <!--Memory Recording</a>-->
            <%--<a href="<%=request.getContextPath()%>/secure/admin/manageyourkitprofiling.jsp?action=StopMemoryRecording">Stop--%>
            <!--Memory Recording</a>-->
            <a href="<%=request.getContextPath()%>/secure/admin/manageyourkitprofiling.jsp?action=DumpMemoryInfo">Take a
                Memory Snapshot</a>
        </td>
        <td valign="top">
            You may want to run the YourKit CPU profiler if you feel you are experiencing performance bottlenecks. You
            must start CPU recording before you try to take a CPU snapshot. Taking a snapshot will automatically stop
            CPU recording.<p/>
            <a href="<%=request.getContextPath()%>/secure/admin/manageyourkitprofiling.jsp?action=StartCPURecording">Start
                CPU Recording</a> |
            <a href="<%=request.getContextPath()%>/secure/admin/manageyourkitprofiling.jsp?action=StopCPURecording">Stop
                CPU Recording</a> |
            <a href="<%=request.getContextPath()%>/secure/admin/manageyourkitprofiling.jsp?action=DumpCPUInfo">Take a
                CPU Snapshot</a> (stops profiler)
        </td>
    </tr>
</table>

<p/>

<%
    if (error != null)
    {
%>
<h3><font color="red"><webwork:text name="'common.words.error'"/>: <%=error%></font></h3>
<% }
%>
<%
    if (message != null)
    {
%>
<h3><font color="green"><%=message%></font></h3>
<% }
%>

<p>
</body>
</html>
