<%@ taglib uri="webwork" prefix="webwork" %>
<%-- This JSP include prints a table (like the top of view issue)
It requires that the issue is the top item on the value stack, and
that various beans / actions are already set. Use it like so:

<webwork:property value="path/to/issueGenericValue">
    <%@ include this file %>
</webwork:property>
--%>
<webwork:bean id="fieldVisibility" name="'com.atlassian.jira.web.bean.FieldVisibilityBean'"/>
<webwork:bean id="permissionCheck" name="'com.atlassian.jira.web.bean.PermissionCheckBean'"/>

<table cellpadding="1" cellspacing="0" border="0" bgcolor="#bbbbbb" width="100%" align="center">
<tr><td width="100%" colspan="2" valign="top">
<table id="issue_header" cellpadding="4" cellspacing="0" border="0" width="100%" bgcolor="#ffffff">
<tr>
    <td bgcolor="#f0f0f0" width="100%" colspan="2" valign="top">
    <table id="issue_header_summary" width="100%" cellpadding="0" cellspacing="0">
        <tr><td bgcolor="#f0f0f0" width="80%" valign="top">
            <b><a href="<%= request.getContextPath() %>/browse/<webwork:property value="/projectManager/project(long('project'))/string('key')" />">
                <webwork:property value="/projectManager/project(long('project'))/string('name')"/></a></b><br>

            <webwork:if test="/subTask == true">
                <webwork:property value="/parentIssueObject">
                    <img src="<%= request.getContextPath() %>/images/icons/link_out_bot.gif" width="16" height="16" border="0" alt="" align="absmiddle" />
                    <webwork:if test="@permissionCheck/issueVisible(.) == true">
                        <b><a id="parent_issue_summary" href="<%= request.getContextPath() %>/browse/<webwork:property value="./key"/>"><webwork:property value="./summary"/></a></b>
                        <span style="font-size: 9px">(<a id="parent_issue_key" href="<%= request.getContextPath() %>/browse/<webwork:property value="./key"/>"><webwork:property value="./key"/></a>)</span>
                    </webwork:if>
                    <webwork:else>
                        <span class="smallgrey"><webwork:property value="./key"/></span>
                    </webwork:else>
                </webwork:property>
            </webwork:if>

            <h3 class="formtitle"><webwork:if test="/subTask == true"><img
                    src="<%= request.getContextPath() %>/images/border/spacer.gif" width="16" height="16" border="0" alt="" />
            </webwork:if><img src="<%= request.getContextPath() %>/images/icons/link_out_bot.gif" width="16" height="16"
                              border="0" alt="" /> <webwork:property value="string('summary')"/></h3>
            <font size="1">
                <webwork:text name="'issue.field.created'"/>: <span class="date"><webwork:property
                    value="/outlookDate/format(timestamp('created'))"/></span> &nbsp;
                <webwork:text name="'issue.field.updated'"/>: <span class="date"><webwork:property
                    value="/outlookDate/format(timestamp('updated'))"/></span>

                <webwork:property value="./long('project')">
                    <webwork:if
                            test="@fieldVisibility/fieldHidden(., 'duedate', ../string('type')) == false && timestamp('duedate')">
                        &nbsp;<webwork:text name="'issue.field.due'"/>: <font color=#336699><webwork:property
                            value="/outlookDate/formatDMY(../timestamp('duedate'))"/></font>
                    </webwork:if>
                </webwork:property>
                <webwork:if test="timestamp('resolutiondate') != null">
                    &nbsp; <webwork:text name="'issue.field.resolution.date'"/>: <span class="date"><webwork:property
                    value="/outlookDate/format(timestamp('resolutiondate'))"/></span>
                </webwork:if>
            </font>
        </td>
            <%-- Display next/previous nav panel unless a search has been executed --%>
            <webwork:if test="searchRequest != null">
                <%--    Next/Previous nav panel--%>
                <webwork:if test="nextPreviousPager/hasCurrentKey == false">
                    <td valign="top" align="right">
                        <table cellpadding="1" cellspacing="0" border="0" bgcolor="#bbbbbb"><tr><td>
                            <table cellpadding="2" cellspacing="0" border="0" bgcolor="#f0f0f0">
                                <tr>
                                    <td bgcolor="#dddddd">
                                        <img src="<%= request.getContextPath() %>/images/icons/undo_16.gif" alt=""
                                             width="16" height="16" border="0" align="absmiddle" />
                                        <b><a href="<%= request.getContextPath() %>/secure/IssueNavigator.jspa"
                                              title="<webwork:text name="'navigator.return.search'"/> (ALT+<webwork:text name="'navigator.return.search.accesskey'"/>)">
                                            <webwork:text name="'navigator.return.search'"/></a></b>
                                        <webwork:if test="searchRequest/name != null">
                                            <font size="1">"<webwork:property value="searchRequest/name"/>"</font>
                                        </webwork:if>
                                    </td>
                                </tr>
                            </table>
                        </td></tr></table>
                    </td>
                </webwork:if>
                <webwork:else>
                    <td valign="top" align="right">
                        <table cellpadding="1" cellspacing="0" border="0" bgcolor="#bbbbbb"><tr><td>
                            <table cellpadding="2" cellspacing="0" border="0" bgcolor="#f0f0f0">
                                <tr>
                                    <td bgcolor="#dddddd">
                                        <img src="<%= request.getContextPath() %>/images/icons/undo_16.gif" alt=""
                                             width="16" height="16" border="0" align="absmiddle" />
                                        <b><a href="<%= request.getContextPath() %>/secure/IssueNavigator.jspa"
                                              title="<webwork:text name="'navigator.return.search'"/> (ALT+<webwork:text name="'navigator.return.search.accesskey'"/>)">
                                            <webwork:text name="'navigator.return.search'"/></a></b>
                                        <webwork:if test="searchRequest/name != null">
                                            <font size="1">"<webwork:property value="searchRequest/name"/>"</font>
                                        </webwork:if>
                                    </td>
                                </tr>
                                <tr>
                                    <td nowrap>
                                        <font size="1">
                                            <webwork:text name="'pager.results.displayissues'">
                                                <webwork:param name="'value0'"><b><webwork:property
                                                        value="nextPreviousPager/currentPosition"/></b></webwork:param>
                                                <webwork:param name="'value1'"><b><webwork:property
                                                        value="nextPreviousPager/currentSize"/></b></webwork:param>
                                            </webwork:text>
                                            <br>
                                        </font>

                                        <div align="center">
                                            <font size="1">
                                                <webwork:if test="nextPreviousPager/previousKey != null">
                                                    <a href="<%= request.getContextPath() %>/browse/<webwork:property value="nextPreviousPager/previousKey" />"
                                                       title="<webwork:text name="'navigator.previous.title'"/> '<webwork:property value="nextPreviousPager/previousKey" />' (ALT+<webwork:text name="'navigator.previous.accesskey'"/>)"
                                                       accesskey="<webwork:text name="'navigator.previous.accesskey'"/>">
                                                        &lt;&lt; <webwork:text name="'navigator.previous'"/></a>
                                                </webwork:if>
                                                <webwork:else>
                                                    <span class="hiddenField">&lt;&lt; <webwork:text
                                                            name="'navigator.previous'"/></span>
                                                </webwork:else>
                                                | <webwork:property value="nextPreviousPager/currentKey"/>
                                                |
                                                <webwork:if test="nextPreviousPager/nextKey != null">
                                                    <a href="<%= request.getContextPath() %>/browse/<webwork:property value="nextPreviousPager/nextKey" />"
                                                       title="<webwork:text name="'navigator.next.title'"/> '<webwork:property value="nextPreviousPager/nextKey" />' (ALT+<webwork:text name="'navigator.next.accesskey'"/>)"
                                                       accesskey="<webwork:text name="'navigator.next.accesskey'"/>">
                                                        <webwork:text name="'navigator.next'"/> &gt;&gt;</a>
                                                </webwork:if>
                                                <webwork:else>
                                                    <span class="hiddenField"> <webwork:text name="'navigator.next'"/> &gt;&gt;</span>
                                                </webwork:else>
                                            </font>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </td></tr></table>
                    </td>
                </webwork:else>
            </webwork:if>
        </tr></table>
</tr>
<%--
<tr bgcolor="#ffffff">
	<td width="20%"><b><webwork:text name="'common.concepts.project'"/>:</b></td>
    <td width="80%"><a href="<%= request.getContextPath() %>/browse/<webwork:property value="/projectManager/project(long('project'))/string('key')" />"><webwork:property value="/projectManager/project(long('project'))/string('name')" /></a></td>
</tr>
--%>
<webwork:property value="./long('project')">
    <webwork:if test="@fieldVisibility/fieldHidden(., 'components', ../string('type')) == false">
        <tr>
            <td width="20%"><b><webwork:text name="'issue.field.components'"/>:</b></td>
            <td width="80%">
                <webwork:property value="/components">
                    <jsp:include page="/includes/snippets/listbynamewithnavlink.jsp">
                        <jsp:param name="navfield" value="component"/>
                    </jsp:include>
                </webwork:property>
            </td>
        </tr>
    </webwork:if>

    <webwork:if test="@fieldVisibility/fieldHidden(., 'versions', ../string('type')) == false">
        <tr>
            <td width="20%"><b><webwork:text name="'issue.field.affectsversions'"/>:</b></td>
            <td width="80%">
                <webwork:property value="/affectedVersions">
                    <jsp:include page="/includes/snippets/listbyname.jsp">
                        <jsp:param name="navfield" value="version"/>
                    </jsp:include>
                </webwork:property>
            </td>
        </tr>
    </webwork:if>

    <webwork:if test="@fieldVisibility/fieldHidden(., 'fixVersions', ../string('type')) == false">
        <tr>
            <td width="20%"><b><webwork:text name="'issue.field.fixversions'"/>:</b></td>
            <td width="80%">
                <webwork:property value="/fixVersions">
                    <jsp:include page="/includes/snippets/listbynamewithnavlink.jsp">
                        <jsp:param name="navfield" value="fixforversion"/>
                    </jsp:include>
                </webwork:property>
            </td>
        </tr>
    </webwork:if>
    <webwork:if test="@fieldVisibility/fieldHidden(., 'security', ../string('type')) == false">
        <webwork:property value="/securityLevel != null"/>
        <webwork:property value="/securityLevel">
            <webwork:if test="./string('name')">
                <tr>
                    <td width="20%">
                        <b><webwork:text name="'issue.field.securitylevel'"/>:</b>
                    </td>
                    <td bgcolor="#ffffff" valign="top" colspan="3">
                        <b><font color="#cc3333"><jira:text2html><webwork:property value="./string('name')" escape="false"/></jira:text2html></font><b>
                        <webwork:if test="./string('description') != null && ./string('description') != ''">
                        <font size="1">(<webwork:property value="./string('description')" escape="false"/>)</font>
                        </webwork:if>
                    </td>
                </tr>
            </webwork:if>
        </webwork:property>
    </webwork:if>
</webwork:property>
</table>
</td></tr></table>
