<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="webwork" prefix="ui" %>

<webwork:if test="/fieldScreenRenderTabs/size > 1">
    <script type="text/javascript" language="JavaScript">
        function showTab(tabId)
        {
            for(i = 1; i <= <webwork:property value="/fieldScreenRenderTabs/size" />; i++)
            {
                var tableObject = document.getElementById('tab' + i);
                var tableCellObject = document.getElementById('tabCell' + i);
                var tabCellTextSelected = document.getElementById('tabCellTextSelected' + i);
                var tabCellTextNotSelected = document.getElementById('tabCellTextNotSelected' + i);
                if (i == tabId)
                {
                    tableObject.className = 'gridTabBox';
                    tableCellObject.className='selectedTabCell';
                    tabCellTextSelected.style.display ='inline';
                    tabCellTextNotSelected.style.display ='none';
                }
                else
                {
                    tableObject.className = 'gridTabBoxHidden';
                    tableCellObject.className = 'unselectedTabCell';
                    tabCellTextSelected.style.display ='none';
                    tabCellTextNotSelected.style.display ='inline';
                }
            }
        }
    </script>

    <%-- Show tab headings --%>
    <table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
        <tr>
        <webwork:iterator value="/fieldScreenRenderTabs" status="'status'">
            <td id="tabCell<webwork:property value="@status/count" />"
                <webwork:if test="@status/count == /selectedTab">class="selectedTabCell"</webwork:if>
                <webwork:else>class="unselectedTabCell"</webwork:else>
                width="1%" nowrap align="center" onClick="showTab(<webwork:property value="@status/count"/>);">

                <webwork:if test="@status/count == /selectedTab">
                    &nbsp;<span id="tabCellTextSelected<webwork:property value="@status/count" />" class="selectedTabFont" style="display: inline;"><webwork:property value="./name"/></span><span id="tabCellTextNotSelected<webwork:property value="@status/count" />" class="unselectedTabFont" style="display: none;"><a href="javascript:showTab(<webwork:property value="@status/count" />)"><webwork:property value="./name" /></a></span>&nbsp;
                </webwork:if>
                <webwork:else>
                    &nbsp;<span id="tabCellTextSelected<webwork:property value="@status/count" />" class="selectedTabFont" style="display: none;"><webwork:property value="./name"/></span><span id="tabCellTextNotSelected<webwork:property value="@status/count" />" class="unselectedTabFont" style="display: inline;"><a href="javascript:showTab(<webwork:property value="@status/count" />)"><webwork:property value="./name" /></a></span>&nbsp;
                </webwork:else>
            </td>
        </webwork:iterator>
            <td width="100%">&nbsp;</td>
        </tr>
    </table>
</webwork:if>

<%-- Show the actual tabs with their fields --%>
<webwork:iterator value="/fieldScreenRenderTabs" status="'status'">
<table id="tab<webwork:property value="@status/count"/>" <webwork:if test="@status/count == /selectedTab">class="gridTabBox"</webwork:if><webwork:else>class="gridTabBoxHidden"</webwork:else> cellpadding="3" cellspacing="1" align="center" width="100%">
    <%-- Show tab's fields --%>
    <webwork:iterator value="./fieldScreenRenderLayoutItems">
        <webwork:property value="./orderableField">
            <%-- If changing this, see if http://confluence.atlassian.com/display/JIRACOM/Displaying+Custom+Fields+with+no+value needs updating --%> 
            <webwork:if test="./value(/issueObject) != null && ./customFieldType/descriptor/viewTemplateExists != false"><%-- don't display custom fields with no values --%>
                <tr id="rowFor<webwork:property value="./id" />">
                    <td bgcolor="#f0f0f0" width="20%" valign="top"><b><webwork:property value="name" />:</b></td>
                    <td bgcolor="#ffffff" width="80%">
                        <webwork:property value="/customFieldHtml(../fieldLayoutItem,., /issueObject)" escape="false" />
                    </td>
                </tr>
            </webwork:if>
        </webwork:property>
    </webwork:iterator>
</table>
</webwork:iterator>
