/**
 * The purpose of this control is to hide a layer when the user clicks away. Not as simple as it sounds. The control must be
 * hidden if:
 *
 * - a layer control of a 'different' type is activated
 * - An iframe is clicked
 * - The layer exists in an iframe and another iframe is click or parent document is clicked
 */


jQuery(function () {

    var $Instances = [];

    function clickDocuments (ignore) {
        AJS.$.each($Instances, function () {
            if (!ignore || ignore !== this) {
                if (this.jQuery){
                    this.jQuery("body").trigger("click");
                    if (this.jQuery.currentLinkedMenu) {
                        this.jQuery.currentLinkedMenu.disableLinkedMenu();
                    }
                }
            }
        });
    }

    function listenForLayerActivation ($instance) {
        $instance("#create_link, .dd-allocated,  textarea, body").live("mousedown", function (e) {
            if (AJS.$(e.target).parents(".aui-dd-parent.active").length === 0 &&
                AJS.$(e.target).parents(".aui-dd-parent.active, .aui-dropdown, .suggestions, .aui-inline-dialog").length === 0 && ! AJS.$(e.target).is(".suggestions")) {
                clickDocuments();
            }
        });
    }

    function installListener (elem) {
        var doc, theQueryMate;
        try {
            doc = AJS.$("body", AJS.$(elem).contents());
            theQueryMate = elem.contentWindow.jQuery;
            if (doc.length === 1 && theQueryMate) {
                $Instances.push(elem.contentWindow);
                listenForLayerActivation(theQueryMate);
            }
        } catch (e) {}
    }

    // hide new style dropdowns when an old style dropdown is opened
    if (typeof jira !== "undefined" && jira.widget && jira.widget.dropdown) {
        AJS.$.aop.before({target: jira.widget.dropdown, method: "displayDropdown"}, function () {
            // hide other layers
            AJS.$(document).trigger("click");
        });
    }
    // hide dropdowns if another is navigated to using access keys
    AJS.$("a[accesskey]").focus(function (e) {
        if (AJS.$(e.target).parents(".aui-dd-parent.active").length === 0) {
            clickDocuments();
        }
    });

    // listen for dropdowns or document being clicked inside of iframes in dom at time of load
    AJS.$("iframe").each(function () {
        installListener(this);
    });

    // listen for dropdowns or document being clicked inside of iframes dynamically inserted via javascript
    AJS.$.aop.after({target: AJS.$.fn, method: "append"}, function (appended) {
        AJS.$("iframe", appended).load(function () {
            installListener(this);
        });
        return appended;
    });

    // gadget dropdowns, need to treat these differently as they have "e.stopPropagation" on the mouse down event so will
    // need to use different handler.
    AJS.$(".gadget .aui-dd-parent").live("mouseup", function () {
        clickDocuments(jQuery);
    });

    // prevents trigger getting focus style after being clicked
    AJS.$("a.aui-dd-link, a.aui-dd-trigger").mousedown(function (e) {
        e.preventDefault();
    });

    // listen for dropdowns opened inside of parent document, will need to hide iframe dropdowns.
    $Instances.push(window);
    listenForLayerActivation(jQuery);

 });