/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public abstract class AbstractComponentAdapter
implements ComponentAdapter,
Serializable {
    private Object componentKey;
    private Class componentImplementation;
    private PicoContainer container;

    protected AbstractComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentImplementation == null) {
            throw new NullPointerException("componentImplementation");
        }
        this.componentKey = componentKey;
        this.componentImplementation = componentImplementation;
        this.checkTypeCompatibility();
        this.checkConcrete();
    }

    public Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    public Class getComponentImplementation() {
        return this.componentImplementation;
    }

    private void checkTypeCompatibility() throws AssignabilityRegistrationException {
        Class componentType;
        if (this.componentKey instanceof Class && !(componentType = (Class)this.componentKey).isAssignableFrom(this.componentImplementation)) {
            throw new AssignabilityRegistrationException(componentType, this.componentImplementation);
        }
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (this.componentImplementation.getModifiers() & 0x400) == 1024;
        if (this.componentImplementation.isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(this.componentImplementation);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getComponentKey() + "]";
    }

    public PicoContainer getContainer() {
        return this.container;
    }

    public void setContainer(PicoContainer picoContainer) {
        this.container = picoContainer;
    }

    public abstract /* synthetic */ void verify() throws PicoVerificationException;

    public abstract /* synthetic */ Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException;
}

